package com.base.browserwhite.ui.activity.bookmark

import android.content.Context
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView.ViewHolder
import com.base.browserwhite.R
import com.base.browserwhite.bean.BookmarkBean
import com.base.browserwhite.databinding.ItemBookmarkFolderBinding
import com.base.browserwhite.utils.XmlEx.inflate
import com.chad.library.adapter4.BaseQuickAdapter

class BookmarkFolderAdapter(
    val selectFolder: String,
    val clickAction: (bookmark: BookmarkBean) -> Unit
) : BaseQuickAdapter<BookmarkBean, BookmarkFolderAdapter.BookmarkFolderViewHolder>() {

    inner class BookmarkFolderViewHolder(view: View) : ViewHolder(view)

    override fun onBindViewHolder(holder: BookmarkFolderViewHolder, position: Int, item: BookmarkBean?) {
        if (item == null) return

        val binding = ItemBookmarkFolderBinding.bind(holder.itemView)
        binding.tvName.text = item.name
        binding.ivSelector.isSelected = item.name == selectFolder
        binding.root.setOnClickListener {
            clickAction.invoke(item)
        }
    }

    override fun onCreateViewHolder(context: Context, parent: ViewGroup, viewType: Int): BookmarkFolderViewHolder {
        return BookmarkFolderViewHolder(R.layout.item_bookmark_folder.inflate(parent))
    }
}