package com.base.browserwhite.ui.activity.bookmark

import android.content.Context
import android.graphics.drawable.ColorDrawable
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView.ViewHolder
import com.base.browserwhite.R
import com.base.browserwhite.bean.BookmarkBean
import com.base.browserwhite.bean.BookmarkBean.Companion.folderRootId
import com.base.browserwhite.databinding.ItemBookmarkBinding
import com.base.browserwhite.utils.XmlEx.inflate
import com.chad.library.adapter4.BaseQuickAdapter


class BookmarkAdapter : BaseQuickAdapter<BookmarkBean, BookmarkAdapter.BookmarkHolder>() {

    private val TAG = "BookmarkAdapter"
    var showSelector: Boolean = false
    var currentFolderId: Long = folderRootId
    var changeFolderAction: ((folderId: Long) -> Unit)? = null
    var moreAction: ((view: View, bean: BookmarkBean) -> Unit)? = null

    inner class BookmarkHolder(view: View) : ViewHolder(view)

    override fun onBindViewHolder(holder: BookmarkHolder, position: Int, item: BookmarkBean?) {
        if (item == null) {
            return
        }

        val binding = ItemBookmarkBinding.bind(holder.itemView)
        val context = holder.itemView.context
        binding.tvName.text = item.name
        if (!item.isFolder) {
            binding.card.radius = context.resources.getDimension(R.dimen.dp_5)
            binding.iv.visibility = View.GONE
            binding.tvLetters.visibility = View.VISIBLE
            binding.tvLetters.background = ColorDrawable(item.color)
            binding.tvLetters.text = item.name.first().toString()
        } else {
            binding.card.radius = 0f
            binding.tvLetters.visibility = View.GONE
            binding.iv.visibility = View.VISIBLE
            binding.iv.setImageResource(R.mipmap.wenjiajia_bookmark)
        }
        binding.ivSelector.isVisible = showSelector
        if (showSelector) {
            binding.ivSelector.isSelected = item.isSelect
        }
        binding.ivMore.isVisible = !showSelector

        binding.root.setOnClickListener {
            if (!item.isFolder) return@setOnClickListener
            currentFolderId = item.id
            changeFolderAction?.invoke(currentFolderId)
        }
        binding.flOperation.setOnClickListener {
            if (showSelector) {
                item.isSelect = !item.isSelect
                notifyItemChanged(position, "aaa")
            } else {
                moreAction?.invoke(it, item)
            }
        }
    }

    override fun onBindViewHolder(holder: BookmarkHolder, position: Int, item: BookmarkBean?, payloads: List<Any>) {
        if (item == null) {
            return
        }

        val binding = ItemBookmarkBinding.bind(holder.itemView)
        val context = holder.itemView.context

        if (payloads.isEmpty()) {
            binding.tvName.text = item.name
            if (!item.isFolder) {
                binding.card.radius = context.resources.getDimension(R.dimen.dp_5)
                binding.iv.visibility = View.GONE
                binding.tvLetters.visibility = View.VISIBLE
                binding.tvLetters.background = ColorDrawable(item.color)
                binding.tvLetters.text = item.name.first().toString()
            } else {
                binding.card.radius = 0f
                binding.tvLetters.visibility = View.GONE
                binding.iv.visibility = View.VISIBLE
                binding.iv.setImageResource(R.mipmap.wenjiajia_bookmark)
            }
            binding.ivSelector.isVisible = showSelector
//            LogEx.logDebug(TAG, "showSelector=$showSelector")
            if (showSelector) {
                binding.ivSelector.isSelected = item.isSelect
            }
            binding.ivMore.isVisible = !showSelector

            binding.root.setOnClickListener {
                if (!item.isFolder) return@setOnClickListener
                currentFolderId = item.id
                changeFolderAction?.invoke(currentFolderId)
            }
            binding.flOperation.setOnClickListener {
                if (showSelector) {
                    item.isSelect = !item.isSelect
                    notifyItemChanged(position, "aaa")
                } else {
                    moreAction?.invoke(it, item)
                }
            }
        } else {
            if (showSelector) {
                binding.ivSelector.isSelected = item.isSelect
                super.onBindViewHolder(holder, position, item, payloads)
            }
        }


    }

    override fun getItemViewType(position: Int, list: List<BookmarkBean>): Int {
        return list[position].viewType

    }

    override fun onCreateViewHolder(context: Context, parent: ViewGroup, viewType: Int): BookmarkHolder {

        val layout = when (viewType) {
            0 -> R.layout.item_bookmark
            else -> R.layout.item_bookmark
        }
        return BookmarkHolder(layout.inflate(parent))
    }


    fun canBeforeFolder(): Boolean {
        return currentFolderId != BookmarkBean.folderRootId
    }

    fun beforeFolder() {
        currentFolderId = BookmarkBean.folderRootId
        changeFolderAction?.invoke(currentFolderId)
    }
}