package com.base.browserwhite.ui.activity.appprocess

import android.content.Context
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.base.browserwhite.R
import com.base.browserwhite.bean.AppBean
import com.base.browserwhite.databinding.ItemAppProcessBinding
import com.base.browserwhite.utils.XmlEx.inflate
import com.chad.library.adapter4.BaseQuickAdapter

class AppBeanAdapter : BaseQuickAdapter<AppBean, AppBeanAdapter.AppHolder>() {
    inner class AppHolder(view: View) : RecyclerView.ViewHolder(view)

    var stopAction: ((pkg: String) -> Unit)? = null
    override fun onBindViewHolder(holder: AppHolder, position: Int, item: AppBean?) {
        if (item == null) return

        val binding = ItemAppProcessBinding.bind(holder.itemView)
        binding.iv.setImageDrawable(item.icon)
        binding.tvName.text = item.name
        binding.tvStop.setOnClickListener {
            stopAction?.invoke(item.packageName)
        }
    }

    override fun onCreateViewHolder(context: Context, parent: ViewGroup, viewType: Int): AppHolder {
        return AppHolder(R.layout.item_app_process.inflate(parent))
    }
}