package com.base.browserwhite.ui.activity.about

import android.annotation.SuppressLint
import android.content.Intent
import android.graphics.Color
import android.net.Uri
import androidx.activity.addCallback
import androidx.core.view.updatePadding
import com.base.browserwhite.BuildConfig
import com.base.browserwhite.R
import com.base.browserwhite.databinding.ActivityAboutBinding
import com.base.browserwhite.help.ConfigHelper
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.utils.BarUtils

class AboutActivity : BaseActivity<ActivityAboutBinding>() {

    override val binding: ActivityAboutBinding by lazy {
        ActivityAboutBinding.inflate(layoutInflater)
    }

    @SuppressLint("SetTextI18n")
    override fun initView() {

        BarUtils.setStatusBarLightMode(this, true)
        BarUtils.setStatusBarColor(this, Color.TRANSPARENT)
//        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())

        binding.tvAppName.text = resources.getString(R.string.app_name)
        binding.tvVersion.text = "v" + BuildConfig.VERSION_NAME
    }

    override fun initListener() {
        super.initListener()
        onBackPressedDispatcher.addCallback {
            finishToMain()
        }
        binding.flFanhui.setOnClickListener {
            onBackPressedDispatcher.onBackPressed()
        }

        binding.tvPrivacy.setOnClickListener {
            val intent = Intent(
                Intent.ACTION_VIEW,
                Uri.parse(ConfigHelper.privacyPolicy)
            )
            startActivity(intent)
        }
    }

}