package com.base.browserwhite.ui.activity

import android.app.Dialog
import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.viewbinding.ViewBinding
import com.base.browserwhite.help.EventUtils
import com.base.browserwhite.utils.ActivityLauncher
import com.base.browserwhite.utils.ActivityManagerUtils

abstract class BaseActivity<T : ViewBinding> : AppCompatActivity() {

    protected abstract val binding: T


    lateinit var launcher: ActivityLauncher


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        launcher = ActivityLauncher(this)
        setContentView(binding.root)

        EventUtils.event("page_${javaClass.simpleName}")
        initView()
        initListener()
    }

    protected abstract fun initView()

    protected open fun initListener() {}


    fun finishToMain() {
        if (this !is MainActivity && !ActivityManagerUtils.getInstance().isActivityInStack(MainActivity::class.java)) {
            startActivity(Intent(this, MainActivity::class.java))
        }
        finish()
    }

    var dialog: Dialog? = null
    override fun onDestroy() {
        super.onDestroy()
        ActivityManagerUtils.getInstance().removeActivity(this)
        if (dialog != null) {
            dialog?.dismiss()
            dialog = null
        }
    }

}