package  com.base.browserwhite.service

import android.app.Notification
import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.PendingIntent
import android.app.Service
import android.content.Context
import android.content.Intent
import android.content.pm.ServiceInfo
import android.graphics.BitmapFactory
import android.graphics.drawable.Icon
import android.os.Build
import android.os.IBinder
import android.widget.RemoteViews
import androidx.core.app.NotificationCompat
import androidx.core.graphics.drawable.IconCompat
import com.base.browserwhite.R
import com.base.browserwhite.bean.ConstObject
import com.base.browserwhite.ui.activity.MainActivity
import com.base.browserwhite.help.EventUtils
import com.base.browserwhite.ui.activity.splash.Splash2Activity
import kotlin.random.Random


/**
 *  常驻通知栏
 */
class StayNotificationService : Service() {

    private val TAG = "StayNotificationService"

    companion object {

        var isRunning = false

        fun Context.startStayNotification() {
            val intent = Intent(this, StayNotificationService::class.java)
            if (Build.VERSION.SDK_INT > Build.VERSION_CODES.TIRAMISU) {
                return
            }

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                startForegroundService(intent)
            } else {
                startService(intent)
            }
        }

        fun Context.restartStartStayNotification() {
            val intent = Intent(this, StayNotificationService::class.java)
            stopService(intent)

            startStayNotification()
        }

    }


    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        if (intent == null) {
            EventUtils.event("onStartCommand", "Foreground System auto launch intent=null isRunning=$isRunning")
            return START_NOT_STICKY
        }
        if (!isRunning) {
            startForeground()
            isRunning = true
        }

        return START_STICKY
    }

    private fun startForeground() {
        val notification = createPermanentNotification(applicationContext)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            startForeground(1, notification, ServiceInfo.FOREGROUND_SERVICE_TYPE_DATA_SYNC)
        } else {
            startForeground(1, notification)
        }
        isRunning = true
    }


    override fun onBind(intent: Intent?): IBinder? {
        return null
    }

    override fun onDestroy() {
        isRunning = false
        super.onDestroy()
    }

    private fun createPermanentNotification(context: Context): Notification {

        val isOngoing = true //是否持续(为不消失的常驻通知)
        val channelName = "File Recovery Foreground Service Channel"
        val channelId = "File_Recovery_Service_Id"
        val category = Notification.CATEGORY_SERVICE
        val contentView = RemoteViews(context.packageName, R.layout.stay_notification_big)
        val expendView = RemoteViews(context.packageName, R.layout.stay_notification_big)

        val requestCode1 = Random.nextInt(1800)
        val intent0 = Intent(context, Splash2Activity::class.java).apply {
            putExtra("actionId", ConstObject.ID_JUNK_CLEANER)
        }
        val pendingIntent1 =
            PendingIntent.getActivity(context, requestCode1, intent0, PendingIntent.FLAG_IMMUTABLE)
        contentView.setOnClickPendingIntent(R.id.ll_1, pendingIntent1)
        expendView.setOnClickPendingIntent(R.id.ll_1, pendingIntent1)

        val requestCode2 = Random.nextInt(1800)
        val intent2 = Intent(context, Splash2Activity::class.java).apply {
            putExtra("actionId", ConstObject.ID_NEWS)
        }
        val pendingIntent2 =
            PendingIntent.getActivity(context, requestCode2, intent2, PendingIntent.FLAG_IMMUTABLE)
        contentView.setOnClickPendingIntent(R.id.ll_2, pendingIntent2)
        expendView.setOnClickPendingIntent(R.id.ll_2, pendingIntent2)

        val requestCode3 = Random.nextInt(1800)
        val intent3 = Intent(context, Splash2Activity::class.java).apply {
            putExtra("actionId", ConstObject.ID_SCAN_CODE)
        }
        val pendingIntent3 =
            PendingIntent.getActivity(context, requestCode3, intent3, PendingIntent.FLAG_IMMUTABLE)
        contentView.setOnClickPendingIntent(R.id.ll_3, pendingIntent3)
        expendView.setOnClickPendingIntent(R.id.ll_3, pendingIntent3)


        val requestCode4 = Random.nextInt(1800)
        val intent4 = Intent(context, Splash2Activity::class.java).apply {
            putExtra("actionId", ConstObject.ID_APP_PROCESS)
        }
        val pendingIntent4 =
            PendingIntent.getActivity(context, requestCode4, intent4, PendingIntent.FLAG_IMMUTABLE)
        contentView.setOnClickPendingIntent(R.id.ll_4, pendingIntent4)
        expendView.setOnClickPendingIntent(R.id.ll_4, pendingIntent4)

        val nfIntent = Intent(context, MainActivity::class.java)
        val pendingIntent =
            PendingIntent.getActivity(context, 0, nfIntent, PendingIntent.FLAG_IMMUTABLE)

        val builder = NotificationCompat.Builder(context, channelId)

        val smallIcon = IconCompat.createFromIcon(
            context, Icon.createWithResource(
                this, R.mipmap.logo_notification_small
            )
        )
        smallIcon?.let {
            builder.setSmallIcon(smallIcon) //设置状态栏内的小图标
        }
        builder.setLargeIcon(BitmapFactory.decodeResource(context.resources, R.mipmap.logo))
        builder.setContentTitle(context.resources.getString(R.string.app_name))
        builder.setContentIntent(pendingIntent) //设置PendingIntent
        builder.setVisibility(NotificationCompat.VISIBILITY_PRIVATE) //设置通知公开可见
        builder.setAutoCancel(false)
        builder.setPriority(NotificationCompat.PRIORITY_MAX) //优先级为：重要通知
        builder.setWhen(System.currentTimeMillis())
        builder.setCustomContentView(contentView)
        builder.setCustomBigContentView(expendView)

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val channel =
                NotificationChannel(channelId, channelName, NotificationManager.IMPORTANCE_LOW)
            channel.lockscreenVisibility = 1
            val notificationManager =
                context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            notificationManager.createNotificationChannel(channel)
            builder.setChannelId(channelId)
        }
        return builder.build()
    }
}