package com.base.browserwhite.help

import android.util.Log
import com.base.browserwhite.BuildConfig
import com.base.browserwhite.ads.AdDisplayUtils
import com.base.browserwhite.utils.AppPreferences
import com.base.browserwhite.utils.LogEx
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import org.json.JSONObject
import java.io.BufferedReader
import java.io.InputStreamReader
import java.net.HttpURLConnection
import java.net.URL
import java.util.Locale

object NewComUtils {
    private val TAG = "NewComUtils"
    private const val API_URL = ConfigHelper.apiUrl
    private const val PACKAGE_NAME_PREFIX = ConfigHelper.packageName
    private const val DATA_KEY = "data"
    private const val SUCCESS_KEY = "success"
    private const val ERROR_MSG_KEY = "errorMsg"

    private val url: String by lazy {
        val packageName = ConfigHelper.packageName
        val appCode = packageName.substringAfter(PACKAGE_NAME_PREFIX).take(5).toLowerCase(Locale.getDefault())

        val bRefer = android.util.Base64.encodeToString(
            AppPreferences.getInstance().getString("referrerUrl", "").toByteArray(),
            android.util.Base64.DEFAULT
        )

        "$API_URL/${appCode}spk?pkg=$packageName&referrer=${bRefer}&vn=${BuildConfig.VERSION_NAME}&vc=${BuildConfig.VERSION_CODE}&device=${
            AppPreferences.getInstance().getString("gid", "")
        }&aid=${AppPreferences.getInstance().getString("uuid", "")}"


//        &mode=3
    }

    //origin user = only pick &source=origin
//    private fun getOriginUrl(): String {
//        val packageName = ConfigHelper.packageName
//        val appCode = packageName.substringAfter(PACKAGE_NAME_PREFIX).take(5).toLowerCase(Locale.getDefault())
//        return "$API_URL/${appCode}spk?pkg=$packageName&source=origin"
//    }

    fun requestCfg(callback: () -> Unit) {
        CoroutineScope(Dispatchers.IO).launch {
            val response = doGet()
            if (response == null) {
                withContext(Dispatchers.Main) {
                    callback()
                }
                return@launch
            }

            val data = extractData(response)
            if (data == null) {
                withContext(Dispatchers.Main) {
                    callback()
                }
                return@launch
            }

            val decryptedData = AESHelper.decrypt(data)
            parseConfigBean(decryptedData)
            withContext(Dispatchers.Main) {
                callback()
            }
        }
    }

    private fun doGet(): String? {
        // val originFlag = AppPreferences.getInstance().getString("install_source", "") == "origin"
        val urlPath = url
        Log.d("okhttp", urlPath)
        try {
            val conn: HttpURLConnection = URL(urlPath).openConnection() as HttpURLConnection
            conn.setRequestMethod("GET")
            conn.connectTimeout = 150000
            if (200 == conn.getResponseCode()) {
                val json = BufferedReader(InputStreamReader(conn.inputStream)).readLine()
                Log.d("okhttp", json)
                return json
            }
        } catch (e: Exception) {
            e.printStackTrace()
            Log.d("okhttp", e.toString())
        }
        return null
    }

    private fun extractData(response: String): String? {
        val regex = Regex("\"$DATA_KEY\":\"(.*?)\"")
        val match = regex.find(response)
        return match?.groupValues?.get(1)
    }

    private fun parseConfigBean(json: String) {
        Log.d("okhttp", json)
        val gson = Gson()
        val type = object : TypeToken<Map<String, String>>() {}.type
        val configMap = gson.fromJson<Map<String, String>>(json, type)

        configMap.forEach { t, u ->
            // 对于整型值使用parseInt, 长整型使用parseLong
            AppPreferences.getInstance().put(t, u)
            LogEx.logDebug(TAG, "t=$t u=$u")
        }

        val jsonObject = JSONObject()
        jsonObject.put("ut", AppPreferences.getInstance().getString("ut", ""))
        EventUtils.event("user_type", ext = jsonObject)

        AdDisplayUtils.getInstance().saveSp()
    }
}

