package com.base.browserwhite.help

import android.os.Build
import androidx.annotation.RequiresApi
import com.android.installreferrer.api.InstallReferrerClient
import com.android.installreferrer.api.InstallReferrerStateListener
import com.base.browserwhite.BuildConfig
import com.base.browserwhite.MyApplication
import com.base.browserwhite.ads.AdmobMaxHelper
import com.base.browserwhite.fcm.RecoveryTimerManager
import com.base.browserwhite.fcm.ScreenStatusReceiver
import com.base.browserwhite.utils.AppPreferences
import org.json.JSONObject

/**
 * call before agree
 */
object InstallHelps {

    private val TAG = "InstallHelps"

    fun init() {
        //InstallReferrer not empty
//        if (!TextUtils.isEmpty(AppPreferences.getInstance().getString("install_source", ""))) {
//            if (AdmobMaxHelper.haveSpAdmobTrueMaxFalse()) {
//                AdmobMaxHelper.initAdmobMaxAd()
//                requestCfg(false)
//            } else {
//                requestCfg(true)
//            }
//            return
//        }


        val referrerClient = InstallReferrerClient.newBuilder(MyApplication.context).build()
        referrerClient.startConnection(object : InstallReferrerStateListener {
            @RequiresApi(Build.VERSION_CODES.O)
            override fun onInstallReferrerSetupFinished(responseCode: Int) {
                try {
                    when (responseCode) {
                        InstallReferrerClient.InstallReferrerResponse.OK -> {
                            val response = referrerClient.installReferrer
                            val installInfo = response.installReferrer
                            val obj = JSONObject()
                            obj.put("referrerUrl", response.installReferrer)
                            obj.put("referrerClickTime", response.referrerClickTimestampSeconds)
                            obj.put("appInstallTime", response.installBeginTimestampSeconds)
                            obj.put("instantExperienceLaunched", installInfo.toString())
                            EventUtils.event("install_referrer", ext = obj, isSingleEvent = true)
                            AppPreferences.getInstance().put("referrer", response.installReferrer)
                            if (listOf("gclid", "facebook", "instagram").all { !installInfo.contains(it, true) }) {
                                //自然用户
                                if (BuildConfig.DEBUG) {
                                    AppPreferences.getInstance().put("install_source", "channel")
                                } else {
                                    AppPreferences.getInstance().put("install_source", "origin")
                                }
                            } else {
                                //渠道用户
                                AppPreferences.getInstance().put("install_source", "channel")
                            }
                            requestCfg(true)
                        }

                        else -> {
                            EventUtils.event("install_referrer_error")
                            requestCfg(true)
                        }
                    }
                } catch (_: Exception) {
                    EventUtils.event("install_referrer_error")
                }

            }

            override fun onInstallReferrerServiceDisconnected() {
            }
        })
    }


    fun requestCfg(callBackAd: Boolean) {
        NewComUtils.requestCfg {
            if (callBackAd) {
                AdmobMaxHelper.initAdmobMaxAd()
            }
            val timerStatus: Int =
                AppPreferences.getInstance().getString("timerS", "1")
                    .toIntOrNull() ?: 1
            if (timerStatus == 0) {
                RecoveryTimerManager.getInstance().stopTaskTimer()
            } else {
                val timerDelay: Int =
                    AppPreferences.getInstance().getString("timerDelay", "1")
                        .toIntOrNull() ?: 1
                val timerInterval: Int =
                    AppPreferences.getInstance().getString("timerInterval", "7")
                        .toIntOrNull() ?: 7
                if (!RecoveryTimerManager.getInstance().isTaskTimerActive) {
                    RecoveryTimerManager.getInstance().scheduleTask(
                        (timerDelay * 60 * 1000).toLong(),
                        (timerInterval * 60 * 1000).toLong()
                    )
                }
            }
            ScreenStatusReceiver.setupScreenStatusListener(MyApplication.context)
        }
    }
}