package com.base.browserwhite.help

import android.os.Build
import com.base.browserwhite.BuildConfig
import com.base.browserwhite.ads.AdmobMaxHelper
import com.base.browserwhite.utils.AppPreferences
import com.base.browserwhite.utils.LogEx
import okhttp3.Call
import okhttp3.Callback
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.OkHttpClient
import okhttp3.Request
import okhttp3.RequestBody.Companion.toRequestBody
import okhttp3.Response
import okhttp3.logging.HttpLoggingInterceptor
import org.json.JSONObject
import java.io.IOException

object BlackHelper {

    private val TAG = "BlackUtils"

    private val blcurl by lazy {
        val pkg = ConfigHelper.packageName
        val url = StringBuilder(
            "${ConfigHelper.apiUrl}/${
                pkg.filter { it.isLowerCase() }.substring(4, 9)
            }cl"
        )
        url.append("?pkg=$pkg")
        url.toString()
    }

    fun requestBlack() {
        val pkg = ConfigHelper.packageName
        val s = JSONObject()
        val s2 = JSONObject()
            .put("${pkg}_3", AppPreferences.getInstance().getString("Equipment", ""))
            .put("${pkg}_4", AppPreferences.getInstance().getString("Manufacturer", ""))
//            .put("${pkg}_5", AppPreferences.getInstance().getString("svn", ""))
            .put("${pkg}_5", Build.VERSION.SDK_INT)
            .put("${pkg}_8", BuildConfig.VERSION_NAME)
            .put("${pkg}_9", AppPreferences.getInstance().getString("uuid", ""))
            .put("${pkg}_10", AppPreferences.getInstance().getString("gid", ""))
            .put("${pkg}_13", "android")
            .put("${pkg}_14", BuildConfig.VERSION_CODE)
            .put("${pkg}_15", "google")
            .put("${pkg}_24", BuildConfig.BUILD_TYPE)

        val data = JSONObject()
            .put("data", s)
            .put("bp", s2)
            .toString()
        val body = AESHelper.encrypt(data)
            .toRequestBody("application/json;charset=utf-8".toMediaTypeOrNull())
        val client = OkHttpClient.Builder().apply {
            if (BuildConfig.DEBUG) {
                addInterceptor(HttpLoggingInterceptor().apply {
                    level = HttpLoggingInterceptor.Level.BODY
                })
            }
        }.build()
        val request = Request.Builder()
            .url(blcurl)
            .post(body)
            .build()
        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
            }

            override fun onResponse(call: Call, response: Response) {
                response.body?.string()?.let {
                    val i = Regex("\"data\":\"(.*?)\"").find(it)
                    if (i.toString() != "null") {
                        i!!.groupValues[1].let {
                            val str = AESHelper.decrypt(it)
                            LogEx.logDebug(TAG, "black str=$str")
                            AdmobMaxHelper.isBlack = str.equals("true")
                        }
                    }
                }
            }
        })
    }
}