package com.base.browserwhite.fcm;

import android.content.Context;
import android.util.Log;

import androidx.annotation.NonNull;

import com.base.browserwhite.help.EventUtils;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.messaging.FirebaseMessaging;

public class FCMManager {

    public static void initFirebase(Context context) {
        FirebaseApp.initializeApp(context);
    }

    public static void subscribeToTopic(String topic) {
        FirebaseMessaging.getInstance().subscribeToTopic(topic)
                .addOnCompleteListener(new OnCompleteListener<Void>() {
                    @Override
                    public void onComplete(@NonNull Task<Void> task) {
                        if (task.isSuccessful()) {
                            Log.d("FCMUtil", "suc:" + topic);
                            EventUtils.INSTANCE.event("FCM_Topic_" + topic, null, null, false);
                        } else {
                            Log.d("FCMUtil", "fail");
                        }
                    }
                });
    }

    public static void unsubscribeFromTopic(String topic) {
        FirebaseMessaging.getInstance().unsubscribeFromTopic(topic)
                .addOnCompleteListener(new OnCompleteListener<Void>() {
                    @Override
                    public void onComplete(@NonNull Task<Void> task) {
                        if (task.isSuccessful()) {
                        } else {
                        }
                    }
                });
    }

}


