
import android.app.NotificationManager
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import com.base.browserwhite.utils.AppPreferences
import com.base.browserwhite.utils.LogEx

class CloseNotificationReceiver : BroadcastReceiver() {

    private val TAG = "CloseNotificationReceiver"

    companion object {
        var Action = "CANCEL_NOTIFICATION"
        var NotificationId = "NOTIFICATION_ID"
    }

    override fun onReceive(context: Context?, intent: Intent?) {
        LogEx.logDebug(TAG, "onReceive")
        val action = intent?.action ?: ""
//        NotificationUtil.stopNotificationHandler()
        if (action == Action) {
            var notificationId = intent?.extras?.getInt(NotificationId, 0) ?: 0
            LogEx.logDebug(TAG, "notificationId=$notificationId")
            val notificationManager = context!!.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            val actionS = AppPreferences.getInstance().getString("actionS", "0") ?: "0"
            runCatching {
                if (actionS.toInt() == 0) {
                    notificationId = 0
                }
            }
            notificationManager.cancel(notificationId)
        }
    }
}