package com.base.browserwhite.bean

import com.base.browserwhite.R
import com.base.browserwhite.utils.AssetUtils.WebsiteJson
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import org.json.JSONObject
import java.lang.reflect.Type


data class WebCategoryBean(
    val id: Int,
    val name: String,
    val iconUrl: String,
)

data class WebSiteGroupBean(
    val category_id: Int = 0,
    val category_name: String = "",
    val items: List<WebSiteBean> = listOf()
)

data class WebSiteBean(
    val id: Int = 0,
    val icon_url: String = "",
    val url: String = "",
    val name: String = "",
    val desc: String = "",
) {
    var localIcon: Int = 0
    var increase = false
    var isAdd: Boolean = false
    var isBookmarkNav: Boolean = false
    var color:Int=0

    companion object {
        fun WebSiteBean.getLocalImage(): Int {
            return when (id) {
                103 -> R.mipmap.instagram_103_local
                111 -> R.mipmap.facebook_111_local
                115 -> R.mipmap.reddit_115_local
                121 -> R.mipmap.pinterest_121_local
                155 -> R.mipmap.whatsapp_155_local
                157 -> R.mipmap.twitter_157_local
                209 -> R.mipmap.snapchat_209_local
                105 -> R.mipmap.netflix_105_local
                109 -> R.mipmap.youtube_109_local
                145 -> R.mipmap.vimeo_145_local
                147 -> R.mipmap.dailymotion_147_local
                123 -> R.mipmap.cnn_123_local
                127 -> R.mipmap.fox_news_127_local
                137 -> R.mipmap.nytimes_137_local
                161 -> R.mipmap.nbc_news_161_local
                171 -> R.mipmap.cbc_sports_171_local
                173 -> R.mipmap.espn_173_local
                203 -> R.mipmap.marca_203_local
                163 -> R.mipmap.chatgpt_163_local
                165 -> R.mipmap.bing_165_local
                167 -> R.mipmap.wikipedia_167_local
                169 -> R.mipmap.yahoo_169_local
                179 -> R.mipmap.linkedin_179_local
                107 -> R.mipmap.hulu_107_local
                143 -> R.mipmap.dailymotion_147_local
                159 -> R.mipmap.tumblr_159_local
                211 -> R.mipmap.tiktok_211_local
                175 -> R.mipmap.vevo_175_local
                177 -> R.mipmap.spotify_177_local
                113 -> R.mipmap.amazon_113_local
                141 -> R.mipmap.ebay_141_local
                149 -> R.mipmap.shopee_149_local
                151 -> R.mipmap.lazada_151_local
                185 -> R.mipmap.cricbuzz_185_local
                189 -> R.mipmap.fantasy_premierleague_189_local
                191 -> R.mipmap.flashscore_191_local
                193 -> R.mipmap.goal_193_local
                201 -> R.mipmap.livescore_201_local
                205 -> R.mipmap.yahoo_sports_205_local
                207 -> R.mipmap.wwe_207_local
                181 -> R.mipmap.airbnb_181_local
                197 -> R.mipmap.hotles_197_local
                215 -> R.mipmap.tripadvisor_215_local
                183 -> R.mipmap.body_buiding_183_local
                187 -> R.mipmap.drugs_187_local
                195 -> R.mipmap.healthline_195_local
                199 -> R.mipmap.kids_health_199_local
                213 -> R.mipmap.who_213_local
                217 -> R.mipmap.t_nation_217_local
                else -> 0

            }
        }
    }
}

fun defaultValue(name: String): Boolean {
    val defaultWebSiteName =
        arrayOf("Amazon", "Youtube", "ChatGPT", "Bing", "Twitter", "Wikipedia", "Facebook", "Ebay", "Tiktok", "Whatsapp")
    return defaultWebSiteName.contains(name)
}

val webCategoryBeanList by lazy {
    webCategoryBeanList(WebsiteJson)
}

val webSiteGroupBeanList by lazy {
    webSiteGroupBeanList(WebsiteJson)
}

fun webCategoryBeanList(json: String): ArrayList<WebCategoryBean> {

    val jsonObject = JSONObject(json)
    val dataJsonObject = jsonObject.getJSONObject("data")
    val categoryList = dataJsonObject.getJSONArray("category_list")

    val list = arrayListOf<WebCategoryBean>()
    for (i in 0 until categoryList.length()) {
        val webSiteBeanJsonObject = categoryList.getJSONObject(i)
        val id = webSiteBeanJsonObject.getInt("id")
        val name = webSiteBeanJsonObject.getString("name")
        val iconUrl = webSiteBeanJsonObject.getString("icon_url")
        list.add(WebCategoryBean(id, name, iconUrl))
    }

    return list
}

fun webSiteGroupBeanList(json: String): List<WebSiteGroupBean> {
    val jsonObject = JSONObject(json)
    val dataJsonObject = jsonObject.getJSONObject("data")

    val groupsList = dataJsonObject.getJSONArray("groups")

    val webSiteGroupBeanType: Type = object : TypeToken<List<WebSiteGroupBean>>() {}.type

    return Gson().fromJson(groupsList.toString(), webSiteGroupBeanType)
}
