package com.base.browserwhite.bean

import com.google.gson.Gson
import com.google.gson.GsonBuilder
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import com.google.gson.JsonSerializationContext
import com.google.gson.JsonSerializer
import com.liulishuo.filedownloader.FileDownloadListener
import com.liulishuo.filedownloader.model.FileDownloadStatus
import java.lang.reflect.Type


data class DownloadBean(
    var downloadId: Int = -1,
    var path: String = "",
    val url: String = "",
    var time: Long = 0,
) {
    var status = FileDownloadStatus.pending
    var name: String = ""
    var progress: Int = -1
    var isTime: Boolean = false
    var uiType: Int = 1
    var size: Long = -1
    var fileDownloadListener: FileDownloadListener? = null
}

class DownloadBeanSerializer() : JsonSerializer<DownloadBean> {
    override fun serialize(src: DownloadBean, typeOfSrc: Type?, context: JsonSerializationContext?): JsonElement {
        val obj = JsonObject()
        obj.addProperty("downloadId", src.downloadId)
        obj.addProperty("path", src.path)
        obj.addProperty("url", src.url)
        obj.addProperty("time", src.time)
        obj.addProperty("status", src.status.toString())
        obj.addProperty("progress", src.progress)
        obj.addProperty("name", src.name)
        obj.addProperty("size", src.size)
        // 这里不包括 fileDownloadListener
        return obj
    }

}

val downloadBeanGson: Gson by lazy {
    GsonBuilder()
        .registerTypeAdapter(DownloadBean::class.java, DownloadBeanSerializer())
        .create()
}
