package com.base.browserwhite.bean

import com.base.browserwhite.utils.AppPreferences

object ConstObject {

    const val GOOGLE = "Google"
    const val BING = "Bing"
    const val YAHOO = "Yahoo"
    const val DUCKDUCKGO = "DuckDuckGo"
    const val YANDEX = "Yandex"
    const val BAIDU = "Baidu"

    const val ID_JUNK_CLEANER = 12001
    const val ID_CLEAN_JUNK_MEMORY = 12009
    const val ID_NEWS = 12002
    const val ID_SCAN_CODE = 12003
    const val ID_APP_PROCESS = 12004

    const val JUNK_CLEANER = "Junk Cleaner"
    const val NEWS = "News"
    const val APP_PROCESS = "App Process"
    const val BOOKMARK = "BookMark"

//    const val REPEAT_PHOTOS = "Repeat Photos"
//    const val SCREENSHOT_CLEANER = "Screenshot Cleaner"
//    const val PRIVACY_SPACE = "Privacy Space"
//    const val WHATSAPP_CLEANER = "WhatsApp Cleaner"
//    const val APP_MANAGER = "App Manager"
//    const val LARGE_FILE = "Large File"
//    const val BATTERY_INFO = "Battery Info"


    const val MIME_TYPE_IMAGE = "image/*"
    const val MIME_TYPE_VIDEO = "video/*"
    const val MIME_TYPE_AUDIO = "audio/*"
    const val MIME_TYPE_PDF = "application/pdf"
    const val MIME_TYPE_DOC = "application/msword"
    const val MIME_TYPE_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document"
    const val MIME_TYPE_XLS = "application/vnd.ms-excel"
    const val MIME_TYPE_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
    const val MIME_TYPE_PPT = "application/vnd.ms-powerpoint"
    const val MIME_TYPE_PPTX = "application/vnd.openxmlformats-officedocument.presentationml.presentation"
    const val MIME_TYPE_APK = "application/vnd.android.package-archive"
    const val MIME_TYPE_ZIP = "application/zip"

    var ifAgreePrivacy = false
        get() {
            return AppPreferences.getInstance().getBoolean("ifAgreePrivacy", field)
        }
        set(value) {
            field = value
            AppPreferences.getInstance().put("ifAgreePrivacy", value, true)
        }

    var searchEngineSp = GOOGLE
        get() {
            return AppPreferences.getInstance().getString("searchEngine", field)
        }
        set(value) {
            field = value
            AppPreferences.getInstance().put("searchEngine", value, true)
        }

    var isFirstMainShow = true
        get() {
            return AppPreferences.getInstance().getBoolean("isFirstMainShow", field)
        }
        set(value) {
            field = value
            AppPreferences.getInstance().put("isFirstMainShow", value, true)
        }

    var mainShowCount = 0
        get() {
            return AppPreferences.getInstance().getInt("mainShowCount", field)
        }
        set(value) {
            field = value
            AppPreferences.getInstance().put("mainShowCount", value, true)
        }


}