package com.base.browserwhite.ads.max

import android.app.Activity
import com.applovin.mediation.MaxAd
import com.applovin.mediation.MaxAdListener
import com.applovin.mediation.MaxError
import com.applovin.mediation.ads.MaxAppOpenAd
import com.base.browserwhite.ads.AdDisplayUtils
import com.base.browserwhite.ads.AdmobMaxHelper.isInterOpenShowing
import com.base.browserwhite.help.ConfigHelper
import com.base.browserwhite.help.EventUtils
import com.base.browserwhite.utils.LogEx
import org.json.JSONObject
import java.util.UUID

object AdMaxOpenUtils {
    private const val TAG = "AdMaxOpenUtils"
    private var appOpenAd: MaxAppOpenAd? = null
    private var openLoadTime = Long.MAX_VALUE
    private var onHidden: (() -> Unit)? = null
    private var loadingListener: ((flag: Boolean) -> Unit)? = null
    private var activityString = ""

    private fun setListener(activity: Activity) {
        activityString = activity::class.java.toString().split(".").last()
        if (appOpenAd == null) {
            appOpenAd = MaxAppOpenAd(ConfigHelper.openAdMaxId, activity)

            appOpenAd?.setListener(object : MaxAdListener {
                override fun onAdLoaded(p0: MaxAd) {
                    LogEx.logDebug(TAG, "广告拉取成功")
                    openLoadTime = System.currentTimeMillis()
                    loadingListener?.invoke(true)
                    loadingListener = null
                    AdMaxEvent.pullAd(p0, "openAd")
                }

                override fun onAdLoadFailed(p0: String, p1: MaxError) {
                    LogEx.logDebug(TAG, "广告拉取失败了，onAdLoadFailed:" + p0)
                    LogEx.logDebug(TAG, "广告拉取失败了，onAdLoadFailed:" + p1.message.toString())
                    LogEx.logDebug(TAG, "广告拉取失败了，onAdLoadFailed:" + p1.code)
                    loadingListener?.invoke(false)
                    loadingListener = null
                    AdDisplayUtils.getInstance().incrementAdRequestFailCount()
                    val reqId = UUID.randomUUID().toString()
                    AdMaxEvent.pullAd(null, "openAd", reqId = reqId, error = p1.message, code = p1.code)
                }

                override fun onAdDisplayed(p0: MaxAd) {
                    AdDisplayUtils.getInstance().incrementAdDisplayCount()
                    AdMaxEvent.showAd(p0, "openAd", activityString)

                    isInterOpenShowing = true
                }

                override fun onAdHidden(p0: MaxAd) {
                    LogEx.logDebug(TAG, "onAdHidden")
                    onHidden?.invoke()
                    onHidden = null
                    loadAppOpenAd(activity)

                    isInterOpenShowing = false
                }

                override fun onAdDisplayFailed(p0: MaxAd, p1: MaxError) {
                    LogEx.logDebug(TAG, "onAdDisplayFailed")
                    onHidden?.invoke()
                    onHidden = null
                    loadAppOpenAd(activity)
                    val obj = JSONObject()
                    obj.put("code", p1.code)
                    obj.put("reason", p1.message)
                    obj.put("ad_unit", "openAd")
                    EventUtils.event("ad_show_error", ext = obj)

                    isInterOpenShowing = false
                }

                override fun onAdClicked(p0: MaxAd) {
                    AdDisplayUtils.getInstance().incrementAdClickCount()
                    AdMaxEvent.clickAd(p0, "openAd")
                }

            })

            appOpenAd?.setRevenueListener(AdMaxEvent.EventOnPaidEventListener())
        }
    }

    fun showAppOpenAd(
        activity: Activity,
        loadCallBack: ((loaded: Boolean) -> Unit)? = null,
        onHidden: (() -> Unit)? = null
    ) {

        setListener(activity)

        if (activity.isFinishing || activity.isDestroyed) {
            return
        }

        if (!AdDisplayUtils.getInstance().shouldShowAd("openAd")) {
            LogEx.logDebug(TAG, "!shouldShowAd")
            onHidden?.invoke()
            return
        }

        if (System.currentTimeMillis() - openLoadTime > 1000 * 60 * 60) {
            LogEx.logDebug(TAG, "openLoadTime > ")
            onHidden?.invoke()
            val obj2 = JSONObject()
            obj2.put("ad_unit", "openAd")
            EventUtils.event("ad_expire", ext = obj2)
            appOpenAd?.loadAd()
        }

//        if (!isAdInit.get()) {
//            EventUtils.event("isAdInit", value = "showAppOpenAd isAdInit=${isAdInit.get()}")
//            onHidden?.invoke()
//            return
//        }


        LogEx.logDebug(TAG, "showAppOpenAd")
        val obj1 = JSONObject()
        obj1.put("ad_unit", "openAd")
        EventUtils.event("ad_prepare_show", ext = obj1)

        isInterOpenShowing = false

        if (appOpenAd?.isReady == true) {
            LogEx.logDebug(TAG, "广告准备好了，展示广告")
            AdMaxOpenUtils.onHidden = onHidden
            appOpenAd?.showAd()
        } else {
            val obj = JSONObject()
            obj.put("reason", "no cache ad")
            obj.put("ad_unit", "openAd")
            EventUtils.event("ad_nocache_pull", ext = obj)
            LogEx.logDebug(TAG, "展示时候，发现广告需要拉取")
            val loaded = loadAppOpenAd(activity)
            if (loaded) {
                loadingListener = { loadResult ->
                    loadCallBack?.invoke(loadResult)
                    LogEx.logDebug(TAG, "loadingListener callback")
                    if (appOpenAd?.isReady == true) {
                        AdMaxOpenUtils.onHidden = onHidden
                        appOpenAd?.showAd()
                    } else {
                        onHidden?.invoke()
                    }
                }
            } else {
                onHidden?.invoke()
            }

        }
    }

    fun loadAppOpenAd(activity: Activity): Boolean {
        setListener(activity)

        if (!AdDisplayUtils.getInstance().shouldShowAd("openAd")) {
            LogEx.logDebug(TAG, "!shouldShowAd")
            return false
        }

        val reqId = UUID.randomUUID().toString()
        val obj = JSONObject()
        obj.put("req_id", reqId)
        obj.put("ad_type", "openAd")
        EventUtils.event("ad_pull_start", ext = obj)
        appOpenAd?.loadAd()
        AdDisplayUtils.getInstance().incrementAdRequestCount()
        return true

    }



}

