package com.base.browserwhite.ads.max

import android.app.Activity
import android.app.Dialog
import com.applovin.mediation.MaxAd
import com.applovin.mediation.MaxAdListener
import com.applovin.mediation.MaxError
import com.applovin.mediation.ads.MaxInterstitialAd
import com.base.browserwhite.R
import com.base.browserwhite.ads.AdDisplayUtils
import com.base.browserwhite.ads.AdmobMaxHelper.isInterOpenShowing
import com.base.browserwhite.ads.AdmobMaxHelper.lastShowedOnHiddenTime
import com.base.browserwhite.ads.CustomDialog
import com.base.browserwhite.help.ConfigHelper
import com.base.browserwhite.help.EventUtils
import com.base.browserwhite.utils.LogEx
import org.json.JSONObject
import java.util.UUID

object AdMaxInterstitialUtils {

    private const val TAG = "AdMaxInterstitialUtils"
    private var interstitialAd: MaxInterstitialAd? = null
    private var interLoadTime = Long.MAX_VALUE
    private var onHidden: (() -> Unit)? = null
    private var loadingListener: (() -> Unit)? = null
    private var activityString: String = ""

    private fun setListener(activity: Activity) {
        activityString = activity::class.java.toString().split(".").last()
        if (interstitialAd == null) {

            interstitialAd = MaxInterstitialAd(ConfigHelper.interAdMaxId, activity)
            interstitialAd?.setListener(object : MaxAdListener {
                override fun onAdLoaded(p0: MaxAd) {
                    LogEx.logDebug(TAG, "onAdLoaded")

                    loadingListener?.invoke()
                    loadingListener = null

                    interLoadTime = System.currentTimeMillis()
                    val reqId = UUID.randomUUID().toString()
                    AdMaxEvent.pullAd(p0, "interAd", reqId = reqId)
                }

                override fun onAdLoadFailed(p0: String, p1: MaxError) {
                    LogEx.logDebug(TAG, "onAdLoadFailed")
                    val reqId = UUID.randomUUID().toString()
                    AdMaxEvent.pullAd(null, "interAd", reqId = reqId, error = p1.message, code = p1.code)
                    AdDisplayUtils.getInstance().incrementAdRequestFailCount()

                    loadingListener?.invoke()
                    loadingListener = null
                }

                override fun onAdDisplayed(p0: MaxAd) {
                    LogEx.logDebug(TAG, "onAdDisplayed")
                    AdDisplayUtils.getInstance().incrementAdDisplayCount()
                    AdMaxEvent.showAd(p0, "interAd", activityString)

                    isInterOpenShowing = true
                }

                override fun onAdHidden(p0: MaxAd) {
                    LogEx.logDebug(TAG, "onAdHidden")
                    onHidden?.invoke()
                    onHidden = null
                    AdMaxOpenUtils.loadAppOpenAd(activity)
//                    loadInterstitialAd(activity)

                    isInterOpenShowing = false
                    lastShowedOnHiddenTime = System.currentTimeMillis()
                }

                override fun onAdClicked(p0: MaxAd) {
                    LogEx.logDebug(TAG, "onAdClicked activity=$activityString")
                    AdDisplayUtils.getInstance().incrementAdClickCount()
                    AdMaxEvent.clickAd(p0, "interAd")
                }


                override fun onAdDisplayFailed(p0: MaxAd, p1: MaxError) {
                    LogEx.logDebug(TAG, "onAdDisplayFailed")
                    onHidden?.invoke()
                    onHidden = null
                    val obj2 = JSONObject()
                    obj2.put("code", p1.code)
                    obj2.put("reason", p1.message)
                    obj2.put("ad_unit", "interAd")
                    EventUtils.event("ad_show_error", ext = obj2)

                    isInterOpenShowing = false
                }
            })
            interstitialAd?.setRevenueListener(AdMaxEvent.EventOnPaidEventListener())
        }
    }

    fun showInterstitialAd(activity: Activity, onHidden: (() -> Unit)? = null) {
        setListener(activity)

        if (activity.isFinishing || activity.isDestroyed) {
            return
        }

        if (isAdExpired()) {
            val obj2 = JSONObject()
            obj2.put("ad_unit", "interAd")
            EventUtils.event("ad_expire", ext = obj2)
            onHidden?.invoke()
            loadInterstitialAd(activity)
            return
        }


        if (!AdDisplayUtils.getInstance().shouldShowAd("interAd")) {
            onHidden?.invoke()
            return
        }

        LogEx.logDebug(TAG, "showInterstitialAd,展示插屏广告")

        val obj1 = JSONObject()
        obj1.put("ad_unit", "interAd")
        EventUtils.event("ad_prepare_show", ext = obj1)
        isInterOpenShowing = false

        if (interstitialAd?.isReady == true) {
            LogEx.logDebug(TAG, "有缓存直接播放。")
            AdMaxInterstitialUtils.onHidden = onHidden
            interstitialAd?.showAd(activity)
        } else {
            LogEx.logDebug(TAG, "展示广告时，没有缓存，需要拉取。")
            val obj2 = JSONObject()
            obj2.put("reason", "no cache ad")
            obj2.put("ad_unit", "interAd")
            EventUtils.event("ad_nocache_pull", ext = obj2)
            val loaded = loadInterstitialAd(activity)
            if (loaded) {
                LogEx.logDebug(TAG, "loaded=true")
                val dialog = showAdDialogAndLoadInterstitial(activity)
                loadingListener = {
                    dialog?.dismiss()
                    if (interstitialAd?.isReady == true) {
                        AdMaxInterstitialUtils.onHidden = onHidden
                        interstitialAd?.showAd(activity)
                    } else {
                        onHidden?.invoke()
                    }
                }
            } else {
                LogEx.logDebug(TAG, "loaded=false")
                onHidden?.invoke()
            }
        }

    }

    private fun isAdExpired(): Boolean {
        return System.currentTimeMillis() - interLoadTime > 1000 * 60 * 60
    }


    private fun showAdDialogAndLoadInterstitial(
        activity: Activity,
    ): Dialog? {
        var customDialog: Dialog? = null
        if (!activity.isFinishing && !activity.isDestroyed) {
            customDialog = CustomDialog(activity, R.layout.dialog_ad_loading)
            // 设置对话框的样式和内容
            customDialog.show()
        }
        return customDialog
    }

    fun loadInterstitialAd(activity: Activity): Boolean {
        setListener(activity)

        if (!AdDisplayUtils.getInstance().shouldShowAd("interAd")) {
            return false
        }

        LogEx.logDebug(TAG, "loadInterstitialAd")
        val reqId = UUID.randomUUID().toString()
        val obj = JSONObject()
        obj.put("req_id", reqId)
        obj.put("ad_type", "interAd")
        EventUtils.event("ad_pull_start", ext = obj)
        interstitialAd?.loadAd()
        AdDisplayUtils.getInstance().incrementAdRequestCount()
        return true
    }

}