package com.base.browserwhite.ads.max

import android.content.Context
import com.applovin.sdk.AppLovinMediationProvider
import com.applovin.sdk.AppLovinSdk
import com.applovin.sdk.AppLovinSdkInitializationConfiguration
import com.base.browserwhite.ads.AdmobMaxHelper.isAdInit
import com.base.browserwhite.help.EventUtils
import com.base.browserwhite.utils.LogEx
import java.util.concurrent.Executors

object AdMaxInit {

    private const val TAG = "AdMaxInit"
    var maxInitAction: (() -> Unit)? = null

    fun Context.initAdMax() {
        // If you want to test your own AppLovin SDK key, change the value here and update the package name in the build.gradle
//        val YOUR_SDK_KEY = "05TMDQ5tZabpXQ45_UTbmEGNUtVAzSTzT6KmWQc5_CuWdzccS4DCITZoL3yIWUG3bbq60QC_d4WF28tUC4gVTF"
        val YOUR_SDK_KEY = "GGPreND6SRmCt1zJgn5faiLGD8c2PVGPLgPpSg7cHanVTud1DhtuI9MmteTqlEviaJ57WnxW68kQDaATJ5z3cW"

        val executor = Executors.newSingleThreadExecutor();
        executor.execute {

            val initConfigBuilder = AppLovinSdkInitializationConfiguration.builder(YOUR_SDK_KEY, this)
            initConfigBuilder.mediationProvider = AppLovinMediationProvider.MAX

            // Enable test mode by default for the current device. Cannot be run on the main thread.
//            val currentGaid = AdvertisingIdClient.getAdvertisingIdInfo(this).id
//            if (currentGaid != null) {
//                initConfigBuilder.testDeviceAdvertisingIds = Collections.singletonList(currentGaid)
//            }


            // Initialize the AppLovin SDK
            val sdk = AppLovinSdk.getInstance(this)
            sdk.initialize(initConfigBuilder.build()) {
                LogEx.logDebug(TAG, "max init")
                isAdInit.set(true)
                maxInitAction?.invoke()
                maxInitAction = null
                EventUtils.event("MaxInit", "MaxInit")
            }

            executor.shutdown()
        }
    }
}