package com.base.browserwhite.ads.admob

import android.app.Activity
import android.app.Dialog
import android.widget.Toast
import com.base.browserwhite.BuildConfig
import com.base.browserwhite.MyApplication
import com.base.browserwhite.R
import com.base.browserwhite.ads.AdDisplayUtils
import com.base.browserwhite.ads.AdmobMaxHelper.lastShowedOnHiddenTime
import com.base.browserwhite.ads.CustomDialog
import com.base.browserwhite.ads.admob.AdmobEvent.clickAd
import com.base.browserwhite.ads.admob.AdmobEvent.pullAd
import com.base.browserwhite.ads.admob.AdmobEvent.showAd
import com.base.browserwhite.help.ConfigHelper
import com.base.browserwhite.help.EventUtils
import com.google.android.gms.ads.AdError
import com.google.android.gms.ads.AdRequest
import com.google.android.gms.ads.FullScreenContentCallback
import com.google.android.gms.ads.LoadAdError
import com.google.android.gms.ads.interstitial.InterstitialAd
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback
import org.json.JSONObject
import java.util.UUID

object AdmobInterstitialUtils {

    private var interAd: InterstitialAd? = null
    private var interLoadTime = Long.MAX_VALUE
    private var adLastDisplayTime: Long = 0
    private val mRequest = AdRequest.Builder().build()


    private fun isAdExpired(): Boolean {
        return System.currentTimeMillis() - interLoadTime > 1000 * 60 * 60
    }


    fun showInterstitialAd(
        activity: Activity,
        isReLoadAd: Boolean = false,
        isShowDialog: Boolean = true,
        onHidden: ((showed: Boolean) -> Unit)? = null
    ) {

        if (activity.isFinishing || activity.isDestroyed) {
            return
        }
        val obj1 = JSONObject()
        obj1.put("ad_unit", "interAd")
        EventUtils.event("ad_prepare_show", ext = obj1)

        if (isAdExpired()) {
            val obj2 = JSONObject()
            obj2.put("ad_unit", "interAd")
            EventUtils.event("ad_expire", ext = obj2)
            interAd = null
            loadInterstitialAd(activity)
            onHidden?.invoke(false)
            return
        }

        if (!AdDisplayUtils.getInstance().shouldShowAd("interAd")) {
            onHidden?.invoke(false)
            return
        }

        if (interAd != null) {
            displayInterstitialAd(activity, onHidden)
        } else {
            showAdDialogAndLoadInterstitial(activity, isReLoadAd, isShowDialog, onHidden)
        }
    }

    fun loadInterstitialAd(activity: Activity, onLoad: (() -> Unit)? = null) {
        if (interAd != null) {
            onLoad?.invoke()
            return
        }
        if (!AdDisplayUtils.getInstance().shouldShowAd("")) {
            onLoad?.invoke()
            return
        }
        val reqId = UUID.randomUUID().toString()
        val obj = JSONObject()
        obj.put("req_id", reqId)
        obj.put("ad_type", "interAd")
        obj.put("from", activity.javaClass.simpleName)
        EventUtils.event("ad_pull_start", ext = obj)
        InterstitialAd.load(
            activity,
            if (BuildConfig.DEBUG) ConfigHelper.interAdmobIdTest else ConfigHelper.interAdmobId,
            mRequest,
            object : InterstitialAdLoadCallback() {
                override fun onAdFailedToLoad(p0: LoadAdError) {
                    interAd = null
                    onLoad?.invoke()
                    pullAd(p0.responseInfo, "interAd", p0.message, reqId = reqId)
                    if (BuildConfig.DEBUG) {
                        Toast.makeText(
                            MyApplication.context, "拉取失败" + p0.message, Toast.LENGTH_SHORT
                        ).show()
                    }

                }

                override fun onAdLoaded(ad: InterstitialAd) {
                    interAd = ad
                    onLoad?.invoke()
                    interLoadTime = System.currentTimeMillis()
                    pullAd(ad.responseInfo, "interAd", reqId = reqId)
                    ad.onPaidEventListener = AdmobEvent.EventOnPaidEventListener(ad)
                }
            })
    }

    private fun showAdDialogAndLoadInterstitial(
        activity: Activity,
        isReLoadAd: Boolean,
        isShowDialog: Boolean,
        onHidden: ((showed: Boolean) -> Unit)?
    ) {
        if (!isShowDialog) {
            onHidden?.invoke(false)
            return
        }
        var mDialog: Dialog? = null
        if (!activity.isFinishing && !activity.isDestroyed) {
            mDialog = CustomDialog(activity, R.layout.dialog_ad_loading)
            // 设置对话框的样式和内容
            mDialog.show()
        }


        loadInterstitialAd(activity) {
            mDialog?.dismiss()
            if (!isReLoadAd) {
                showInterstitialAd(activity, true, false) {
                    onHidden?.invoke(it)
                }
            }
        }
        if (isReLoadAd) {
            mDialog?.dismiss()
            onHidden?.invoke(false)
        }
    }

    private fun displayInterstitialAd(activity: Activity, onHidden: ((showed: Boolean) -> Unit)? = null) {
        val thisInterAd = interAd
        interAd = null
        thisInterAd?.fullScreenContentCallback = object : FullScreenContentCallback() {
            override fun onAdClicked() {
                clickAd(thisInterAd?.responseInfo, "interAd")
                AdDisplayUtils.getInstance().incrementAdClickCount()
            }

            override fun onAdDismissedFullScreenContent() {
                interAd = null
                onHidden?.invoke(true)
                loadInterstitialAd(activity)
                lastShowedOnHiddenTime = System.currentTimeMillis()
            }

            override fun onAdFailedToShowFullScreenContent(p0: AdError) {
                interAd = null
                onHidden?.invoke(false)
                loadInterstitialAd(activity)
            }

            override fun onAdShowedFullScreenContent() {
                showAd(thisInterAd?.responseInfo, "interAd", activity)
                AdDisplayUtils.getInstance().incrementAdDisplayCount()
                adLastDisplayTime = System.currentTimeMillis() / 1000
            }
        }
        thisInterAd?.show(activity)
    }
}