package com.base.browserwhite.ads.admob

import android.content.Context
import android.os.Bundle
import android.view.View
import android.view.ViewGroup
import android.view.ViewTreeObserver
import androidx.core.view.children
import com.base.browserwhite.BuildConfig
import com.base.browserwhite.help.ConfigHelper
import com.base.browserwhite.utils.AppPreferences
import com.base.browserwhite.utils.LogEx
import com.google.ads.mediation.admob.AdMobAdapter
import com.google.android.gms.ads.AdListener
import com.google.android.gms.ads.AdRequest
import com.google.android.gms.ads.AdSize
import com.google.android.gms.ads.AdView
import java.util.UUID

object AdmobBannerUtils {

    private const val TAG = "AdmobBannerUtils"
    private var adView: AdView? = null
    private var listener: ViewTreeObserver.OnGlobalLayoutListener? = null

    fun showCollapsibleBannerAd(context: Context, parent: ViewGroup) {
        val isShowBanner = AppPreferences.getInstance().getString("isShowBanner", "0").toInt()
        if (isShowBanner == 0) {
            return
        }
        if (adView != null) {
            adView?.destroy()
        }
        adView = AdView(context)
        adView?.tag = "CollapsibleBannerAd"
//        parent.removeAllViews()
        val list = parent.children
        list.forEach {
            if (it.tag != "zhanweitu") {
                parent.removeView(it)
            }
        }
        parent.addView(adView)
        listener = ViewTreeObserver.OnGlobalLayoutListener {
            val screenPixelDensity = context.resources.displayMetrics.density
            val adWidth = (parent.width / screenPixelDensity).toInt()
            val adSize = AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize(context, adWidth)
            adView?.adUnitId = if (BuildConfig.DEBUG) ConfigHelper.bannerAdmobIdTest else ConfigHelper.bannerAdmobId
            adView?.setAdSize(adSize)
            loadCollapsibleBanner(parent)
            parent.viewTreeObserver.removeOnGlobalLayoutListener(listener)
        }
        parent.viewTreeObserver.addOnGlobalLayoutListener(listener)
    }

    private fun loadCollapsibleBanner(parent: ViewGroup) {

        val extras = Bundle()
        extras.putString("collapsible", "bottom")
        extras.putString("collapsible_request_id", UUID.randomUUID().toString())
        val adRequest =
            AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter::class.java, extras).build()
        adView?.adListener =
            object : AdListener() {
                override fun onAdLoaded() {
                    LogEx.logDebug(TAG, "onAdLoaded")
                }

                override fun onAdOpened() {
                    LogEx.logDebug(TAG, "onAdOpened")
                }

                override fun onAdClosed() {
                    super.onAdClosed()
                    LogEx.logDebug(TAG, "onAdClosed")
                    val removeList = arrayListOf<View>()
                    parent.children.forEach {
                        if (it.tag != "CollapsibleBannerAd") {
                            removeList.add(it)
                        }
                    }
                    removeList.forEach {
                        parent.removeView(it)
                    }
                }
            }
        adView?.loadAd(adRequest)
    }

}