package com.base.browserwhite.ads

import android.app.Activity
import android.util.Log
import android.view.ViewGroup
import com.base.browserwhite.MyApplication
import com.base.browserwhite.R
import com.base.browserwhite.ads.admob.AdmobInterstitialUtils
import com.base.browserwhite.ads.admob.AdmobNativeUtils
import com.base.browserwhite.ads.admob.AdmobOpenUtils
import com.base.browserwhite.ads.max.AdMaxInit
import com.base.browserwhite.ads.max.AdMaxInit.initAdMax
import com.base.browserwhite.ads.max.AdMaxInterstitialUtils
import com.base.browserwhite.ads.max.AdMaxNativeUtils
import com.base.browserwhite.ads.max.AdMaxOpenUtils
import com.base.browserwhite.help.EventUtils
import com.base.browserwhite.utils.AppPreferences
import com.base.browserwhite.utils.LogEx
import com.google.android.gms.ads.MobileAds
import java.util.concurrent.atomic.AtomicBoolean

object AdmobMaxHelper {
    private val TAG = "AdmobMaxHelper"
    var isAdInit = AtomicBoolean(false)
    var isBlack: Boolean = false
    var isInterOpenShowing: Boolean = false

//    if (System.currentTimeMillis() - lastShowInter > 10 * 1000 * 1000 || lastShowInter == 0L) {
//        AdmobMaxHelper.admobMaxShowInterstitialAd(this@WebBrowserActivity, false) {
//            if (it) {
//                lastShowInter = System.currentTimeMillis()
//            }
//            finishToMain()
//        }
//    } else {
//        finishToMain()
//    }
    var lastShowInter = 0L

    private fun getSpAdmobTrueMaxFalse(): Boolean {
        val ss = AppPreferences.getInstance().getString("admobTrueMaxFalse", "1").toInt()
        return ss == 1
    }

    fun showBackInterAdSp(): Boolean {
        val isShowBackIntAd = AppPreferences.getInstance().getString("isShowBackIntAd", "0").toInt()
        //1要看插屏 0不看
        return isShowBackIntAd == 1
    }

    fun showDeleteAdSp(): Boolean {
        val isDeleteInterAd = AppPreferences.getInstance().getString("isDeleteInterAd", "0").toInt()
        //1要看插屏 0不看
        return isDeleteInterAd == 1
    }


    fun initAdmobMaxAd() {
        if (isBlack) {
            return
        }
        if (getSpAdmobTrueMaxFalse()) {
            if (!isAdInit.get()) {
                LogEx.logDebug(TAG, "init sp Admob")
                MobileAds.initialize(MyApplication.context) { initializationStatus ->
                    isAdInit.set(true)
                    EventUtils.event("AdmobInit", "AdmobInit")
                }
            }
        } else {
            if (!isAdInit.get()) {
                LogEx.logDebug(TAG, "init sp AdMax")
                MyApplication.context.initAdMax()
            }
        }
    }


    //展示广告关闭时赋值
    var lastShowedOnHiddenTime = 0L
    fun admobMaxShowInterstitialAd(activity: Activity, isLoading: Boolean = true, onHidden: ((showed: Boolean) -> Unit)? = null) {
        if (isBlack) {
            EventUtils.event("ad_black", "interAd")
            onHidden?.invoke(false)
            return
        }
        val isShowLoadingAd = AppPreferences.getInstance().getString("isShowLoadingAd", "0").toInt()
        if (isShowLoadingAd == 0 && isLoading) {
            EventUtils.event("ad_switch_close")
            onHidden?.invoke(false)
            return
        }
        val adInterval = AppPreferences.getInstance().getString("adInterval", "0").toInt()
        if ((System.currentTimeMillis() - lastShowedOnHiddenTime) < adInterval * 1000 && lastShowedOnHiddenTime != 0L) {
            onHidden?.invoke(false)
            EventUtils.event("ad_interval")
            return
        }

        if (getSpAdmobTrueMaxFalse()) {
            AdmobInterstitialUtils.showInterstitialAd(activity) {
                onHidden?.invoke(it)
            }
        } else {
            AdMaxInterstitialUtils.showInterstitialAd(activity) {
                onHidden?.invoke(true)
            }
        }
    }

    fun admobMaxShowOpenAd(
        activity: Activity, showBeforeAction: (flag: Boolean) -> Unit,
        onHidden: (() -> Unit)? = null,
    ) {
        if (isBlack) {
            EventUtils.event("ad_black", "openAd")
            onHidden?.invoke()
            return
        }
        if (getSpAdmobTrueMaxFalse()) {
            AdmobOpenUtils.showAppOpenAd(activity, showBefore = showBeforeAction) {
                onHidden?.invoke()
            }
        } else {
            AdMaxOpenUtils.showAppOpenAd(activity, loadCallBack = showBeforeAction) {
                onHidden?.invoke()
            }
        }
    }

    fun admobMaxShowNativeAd(activity: Activity, parent: ViewGroup, where: String = "") {
        if (isBlack) {
            return
        }
        if (getSpAdmobTrueMaxFalse()) {

            var layout = R.layout.layout_admob_native_custom
            when (where) {
                "QrcResultActivity" -> layout = R.layout.layout_admob_native_qrcr
            }

            AdmobNativeUtils.showNativeAd(activity, parent, layout)
        } else {
            var layout = R.layout.layout_max_native_small
//            if (where == 0) {
//                layout = R.layout.layout_max_native_small_f8f8f8
//            }
//            if (where == 1) {
//                layout = R.layout.layout_max_native_big
//            }
//            if (where == 2) {
//                layout = R.layout.layout_max_native_big_2
//            }
            AdMaxNativeUtils.showNativeAd(activity, parent, layout)
        }
    }

    fun preloadAd(activity: Activity) {
        if (isBlack) {
            return
        }

        if (getSpAdmobTrueMaxFalse()) {
//            com.base.browserwhite.ads.admob.AdmobOpenUtils.loadAppOpenAd()
            AdmobInterstitialUtils.loadInterstitialAd(activity)
        } else {
            if (isAdInit.get()) {
//                com.base.browserwhite.ads.max.AdMaxOpenUtils.loadAppOpenAd(activity)
                AdMaxInterstitialUtils.loadInterstitialAd(activity)
            } else {
                AdMaxInit.maxInitAction = {
                    Log.d(TAG, "max init suc")
//                    com.base.browserwhite.ads.max.AdMaxOpenUtils.loadAppOpenAd(activity)
//                    com.base.browserwhite.ads.max.AdMaxInterstitialUtils.loadInterstitialAd(activity)
                }
            }
        }
    }

}