package com.base.browserwhite.ads;


import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

import com.base.browserwhite.BuildConfig;
import com.base.browserwhite.MyApplication;
import com.base.browserwhite.help.EventUtils;
import com.base.browserwhite.utils.AppPreferences;
import com.base.browserwhite.utils.LogEx;
import com.facebook.appevents.AppEventsLogger;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class AdDisplayUtils {
    private String TAG = "AdDisplayUtils";
    public static final int DEFAULT_MAX_AD_REQUEST_COUNT = 100; // 广告请求次数限制默认值
    public static final int DEFAULT_MAX_AD_REQUEST_FAIL_COUNT = 20; // 单个广告点击次数限制默认值
    public static final int DEFAULT_MAX_AD_DISPLAY_COUNT = 45; // 总广告展示次数限制默认值
    public static final int DEFAULT_MAX_AD_CLICK_COUNT = 10; // 单个广告点击次数限制默认值

    private static final String AD_PREFS_NAME = "ad_prefs"; // SharedPreferences 名称

    private static AdDisplayUtils instance; // 单例对象

    private String currentDate; // 当前日期

    private Context context = MyApplication.context;

    public void saveSp() {

        this.maxAdRequestCount = Integer.parseInt(AppPreferences.getInstance().getString("adMaxRequestCount", String.valueOf(DEFAULT_MAX_AD_REQUEST_COUNT)));
        saveMaxAdRequestCount();

        this.maxAdRequestFailCount = Integer.parseInt(AppPreferences.getInstance().getString("adRequestFailCount", String.valueOf(DEFAULT_MAX_AD_REQUEST_FAIL_COUNT)));
        saveMaxAdRequestFailCount();

        this.maxAdDisplayCount = Integer.parseInt(AppPreferences.getInstance().getString("adShowCount", String.valueOf(DEFAULT_MAX_AD_DISPLAY_COUNT)));
        saveMaxAdDisplayCount();

        this.maxAdClickCount = Integer.parseInt(AppPreferences.getInstance().getString("adClickCount", String.valueOf(DEFAULT_MAX_AD_CLICK_COUNT)));
        saveMaxAdClickCount();

    }

    private AdDisplayUtils() {
        currentDate = getCurrentDate();
        SharedPreferences prefs = context.getSharedPreferences(AD_PREFS_NAME, 0);

        maxAdRequestCount = prefs.getInt(MAX_AD_REQUEST_COUNT_KEY, DEFAULT_MAX_AD_REQUEST_COUNT);
        maxAdRequestFailCount = prefs.getInt(MAX_AD_REQUEST_FAIL_COUNT_KEY, DEFAULT_MAX_AD_REQUEST_FAIL_COUNT);
        maxAdDisplayCount = prefs.getInt(MAX_AD_DISPLAY_COUNT_KEY, DEFAULT_MAX_AD_DISPLAY_COUNT);
        maxAdClickCount = prefs.getInt(MAX_AD_CLICK_COUNT_KEY, DEFAULT_MAX_AD_CLICK_COUNT);

        adRequestCount = prefs.getInt(getAdRequestCountKey(), 0);
        adRequestFailCount = prefs.getInt(getAdRequestFailCountKey(), 0);
        adDisplayCount = prefs.getInt(getAdDisplayCountKey(), 0);
        adClickCount = prefs.getInt(getAdClickCountKey(), 0);
    }

    public static synchronized AdDisplayUtils getInstance() {
        if (instance == null) {
            instance = new AdDisplayUtils();
        }
        return instance;
    }

    public boolean shouldSendAdRequest() {
        return adRequestCount < maxAdRequestCount;
    }

    public boolean shouldIncrementRequestFailAd() {
        return adRequestFailCount < maxAdRequestFailCount;
    }

    public boolean shouldDisplayAd() {
        return adDisplayCount < maxAdDisplayCount;
    }

    public boolean shouldIncrementClickCount() {
        return adClickCount < maxAdClickCount;
    }

    public boolean shouldShowAd(String ad_unit) {
        if (BuildConfig.DEBUG) {
            return true;
        }
        boolean shouldDisplayAd = shouldDisplayAd();
        boolean shouldIncrementClickCount = shouldIncrementClickCount();
        boolean shouldIncrementRequestFailAd = shouldIncrementRequestFailAd();
        boolean shouldSendAdRequest = shouldSendAdRequest();

        LogEx.INSTANCE.logDebug(TAG, "shouldSendAdRequest=" + shouldSendAdRequest, false);
        LogEx.INSTANCE.logDebug(TAG, "shouldIncrementRequestFailAd=" + shouldIncrementRequestFailAd, false);
        LogEx.INSTANCE.logDebug(TAG, "shouldIncrementClickCount=" + shouldIncrementClickCount, false);
        LogEx.INSTANCE.logDebug(TAG, "shouldDisplayAd=" + shouldDisplayAd, false);

        boolean show = shouldIncrementRequestFailAd && shouldSendAdRequest && shouldDisplayAd && shouldIncrementClickCount;
        if (!show) {
            LogEx.INSTANCE.logDebug("glc", "!shouldShowAd", false);
            JSONObject obj2 = new JSONObject();
            try {
                obj2.put("reason", "ad limit");
                obj2.put("shouldSendAdRequest", shouldSendAdRequest);
                obj2.put("shouldIncrementRequestFailAd", shouldIncrementRequestFailAd);
                obj2.put("shouldDisplayAd", shouldDisplayAd);
                obj2.put("shouldIncrementClickCount", shouldIncrementClickCount);


                obj2.put("adDisplayCount", adDisplayCount);
                obj2.put("maxAdDisplayCount", maxAdDisplayCount);

                obj2.put("adClickCount", adClickCount);
                obj2.put("maxAdClickCount", maxAdClickCount);

                obj2.put("adRequestFailCount", adRequestFailCount);
                obj2.put("adRequestCount", maxAdRequestFailCount);

                obj2.put("adRequestCount", adRequestCount);

                obj2.put("ad_unit", ad_unit);
                EventUtils.INSTANCE.event("ad_show_error", null, obj2, false);
            } catch (JSONException ignored) {

            }
        }
        return show;
    }


    //region AdRequestCount
    private int maxAdRequestCount = 0; // 最大广告请求次数
    private int adRequestCount = 0; // 当前广告请求次数
    private static final String MAX_AD_REQUEST_COUNT_KEY = "max_ad_request_count"; // 广告请求次数限制的键
    private static final String AD_REQUEST_COUNT_KEY = "ad_request_count";//广告请求次数

    private void saveMaxAdRequestCount() {
        SharedPreferences prefs = context.getSharedPreferences(AD_PREFS_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(MAX_AD_REQUEST_COUNT_KEY, maxAdRequestCount);
        editor.apply();
    }

    public void incrementAdRequestCount() {
        if (!currentDate.equals(getCurrentDate())) {
            currentDate = getCurrentDate();
            adRequestCount = 0;
        }
        adRequestCount++;
        saveAdRequestCount();
    }

    private String getAdRequestCountKey() {
        return AD_REQUEST_COUNT_KEY + "_" + currentDate;
    }

    private void saveAdRequestCount() {
        SharedPreferences prefs = context.getSharedPreferences(AD_PREFS_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(getAdRequestCountKey(), adRequestCount);
        editor.apply();
    }
    //endregion

    //region AdRequestFailCount
    private int maxAdRequestFailCount; // 请求失败总
    private int adRequestFailCount = 0; // 请求失败当前

    private static final String MAX_AD_REQUEST_FAIL_COUNT_KEY = "max_ad_request_fail_count"; // 单个广告点击次数限制的键
    private static final String AD_REQUEST_FAIL_COUNT_KEY = "ad_request_fail_count"; // 单个广告点击次数限制的键

    private void saveMaxAdRequestFailCount() {
        SharedPreferences prefs = context.getSharedPreferences(AD_PREFS_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(MAX_AD_REQUEST_FAIL_COUNT_KEY, maxAdRequestFailCount);
        editor.apply();
    }

    public void incrementAdRequestFailCount() {
        if (!currentDate.equals(getCurrentDate())) {
            currentDate = getCurrentDate();
            adRequestFailCount = 0;
        }
        adRequestFailCount++;
        saveAdRequestFailCount();
        Log.d("glc", "广告请求失败：" + adRequestFailCount);
    }

    private String getAdRequestFailCountKey() {
        return AD_REQUEST_FAIL_COUNT_KEY + "_" + currentDate;
    }

    private void saveAdRequestFailCount() {
        SharedPreferences prefs = context.getSharedPreferences(AD_PREFS_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(getAdRequestFailCountKey(), adRequestFailCount);
        editor.apply();
    }
    //endregion

    //region AdDisplayCount
    private int maxAdDisplayCount; // 总广告展示次数限制
    private int adDisplayCount = 0; // 当前广告展示次数
    private static final String MAX_AD_DISPLAY_COUNT_KEY = "max_ad_display_count"; // 总广告展示次数限制的键

    private static final String AD_DISPLAY_COUNT_KEY = "ad_display_count"; // 广告展示次数的键

    private void saveMaxAdDisplayCount() {
        SharedPreferences prefs = context.getSharedPreferences(AD_PREFS_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(MAX_AD_DISPLAY_COUNT_KEY, maxAdDisplayCount);
        editor.apply();
    }

    public void incrementAdDisplayCount() {
        if (!currentDate.equals(getCurrentDate())) {
            currentDate = getCurrentDate();
            adDisplayCount = 0;
        }
        adDisplayCount++;


        int max = AppPreferences.getInstance().getInt("facebookAdShowEventCount", 3);
        if (adClickCount >= max && max != -1) {
            AppEventsLogger logger = AppEventsLogger.newLogger(context);
            logger.logEvent("ad_show");
            AppPreferences.getInstance().put("facebookAdShowEventCount", -1);
        }

        saveAdDisplayCount();
    }


    private String getAdDisplayCountKey() {
        return AD_DISPLAY_COUNT_KEY + "_" + currentDate;
    }

    private void saveAdDisplayCount() {
        SharedPreferences prefs = context.getSharedPreferences(AD_PREFS_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(getAdDisplayCountKey(), adDisplayCount);
        editor.apply();
    }
    //endregion

    //region AdClickCount
    public int maxAdClickCount; // 单个广告点击次数限制
    private int adClickCount = 0; // 当前广告点击次数

    private static final String MAX_AD_CLICK_COUNT_KEY = "max_ad_click_count"; // 单个广告点击次数限制的键
    private static final String AD_CLICK_COUNT_KEY = "ad_click_count"; // 广告点击次数的键

    private void saveMaxAdClickCount() {
        SharedPreferences prefs = context.getSharedPreferences(AD_PREFS_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(MAX_AD_CLICK_COUNT_KEY, maxAdClickCount);
        editor.apply();
    }

    public void incrementAdClickCount() {
        LogEx.INSTANCE.logDebug(TAG, "incrementAdClickCount", false);
        if (!currentDate.equals(getCurrentDate())) {
            currentDate = getCurrentDate();
            adClickCount = 0;
        }
        adClickCount++;
        saveAdClickCount();
    }

    private String getAdClickCountKey() {
        return AD_CLICK_COUNT_KEY + "_" + currentDate;
    }

    public void setAdClickCount(int s) {
        if (!currentDate.equals(getCurrentDate())) {
            currentDate = getCurrentDate();
            adClickCount = 0;
        }
        adClickCount = s;
        saveAdClickCount();
    }

    private void saveAdClickCount() {
        SharedPreferences prefs = context.getSharedPreferences(AD_PREFS_NAME, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(getAdClickCountKey(), adClickCount);
        editor.apply();
        LogEx.INSTANCE.logDebug(TAG, "adClickCount=" + adClickCount, false);
    }
    //endregion


    public String getCurrentDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        Date currentDate = Calendar.getInstance().getTime();
        return dateFormat.format(currentDate);
    }


}
