plugins {
    alias(libs.plugins.androidApplication)
    alias(libs.plugins.jetbrainsKotlinAndroid)
    id("com.google.gms.google-services")
    id("com.google.firebase.crashlytics")
}

android {

    namespace = "com.base.browserwhite"
    compileSdk = 34

    defaultConfig {
        applicationId = "com.base.browserwhite"
        minSdk = 24
        targetSdk = 34
        versionCode = 1
        versionName = "1.0"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        setProperty("archivesBaseName", "aibrowser-v${versionName}")
    }
    signingConfigs {

        create("release") {
            storeFile = file("../smartcl.jks")
            storePassword = "123456"
            keyAlias = "key0"
            keyPassword = "123456"
        }
    }


    buildTypes {
        release {
            isMinifyEnabled = true
            isShrinkResources = true
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")

            // 设置是否要自动上传
            firebaseCrashlytics {
                mappingFileUploadEnabled = true
            }
            signingConfig = signingConfigs.getByName("release")
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }
    kotlinOptions {
        jvmTarget = "1.8"
    }
    buildFeatures {
        viewBinding = true
        buildConfig = true
    }
}
gradle.taskGraph.whenReady {
    tasks.forEach { task ->
        if (task.name.contains("uploadCrashlyticsMappingFile")) {
            task.enabled = false
        }
    }
}


dependencies {

    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.appcompat)
    implementation(libs.material)
    implementation(libs.androidx.activity)
    implementation(libs.androidx.constraintlayout)
    implementation(libs.core)
    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso.core)

    //广告
    implementation("com.google.android.gms:play-services-ads:23.1.0")
    implementation("com.google.ads.mediation:applovin:12.4.3.0")
    implementation("com.google.ads.mediation:facebook:6.17.0.0")
    implementation("com.google.ads.mediation:mintegral:16.7.21.0")
    implementation("com.google.ads.mediation:pangle:5.9.0.4.0")

    //max
    implementation("com.applovin:applovin-sdk:+")
//    implementation("com.applovin.mediation:google-adapter:+")
//    implementation("com.applovin.mediation:facebook-adapter:+")
//    implementation("com.applovin.mediation:mintegral-adapter:+")
//    implementation("com.applovin.mediation:bytedance-adapter:+")
//    implementation("com.applovin.mediation:ironsource-adapter:+")

    //第三方UI
    implementation("com.airbnb.android:lottie:6.4.0")
    implementation("com.github.bumptech.glide:glide:4.16.0")
    implementation("com.github.angcyo.DslTablayout:TabLayout:3.5.5")
    implementation("de.hdodenhof:circleimageview:3.1.0")
    implementation("com.github.pokercc:ExpandableRecyclerView:0.9.3")
    implementation("io.github.cymchad:BaseRecyclerViewAdapterHelper4:4.1.4")
    implementation("com.mikhaellopez:circularprogressbar:3.1.0")
    implementation("com.github.zhpanvip:viewpagerindicator:1.2.3")
    implementation("com.github.JavaNoober.BackgroundLibrary:libraryx:1.7.6")

    //相机
    val cameraxVersion = "1.2.2"
    implementation("androidx.camera:camera-core:${cameraxVersion}")
    implementation("androidx.camera:camera-camera2:${cameraxVersion}")
    implementation("androidx.camera:camera-view:${cameraxVersion}")
    implementation("androidx.camera:camera-lifecycle:${cameraxVersion}")

    //播放器
    implementation("androidx.media3:media3-exoplayer:1.4.0")
    implementation("androidx.media3:media3-ui:1.4.0")

    //网络请求和解析
    implementation("com.google.code.gson:gson:2.11.0")
    // define a BOM and its version
    implementation(platform("com.squareup.okhttp3:okhttp-bom:4.12.0"))
    // define any required OkHttp artifacts without version
    implementation("com.squareup.okhttp3:okhttp")
    implementation("com.squareup.okhttp3:logging-interceptor")
    //支持暂停恢复下载
    implementation("com.liulishuo.filedownloader:library:1.7.7")



    //firebase
    implementation(platform("com.google.firebase:firebase-bom:32.3.1"))
    implementation("com.google.firebase:firebase-messaging")
    implementation("com.google.firebase:firebase-analytics-ktx")
    implementation("com.google.firebase:firebase-crashlytics")

    //机器学习二维码扫描
    implementation("com.google.mlkit:barcode-scanning:17.3.0")
    // Use this dependency to use the dynamically downloaded model in Google Play Services
//    implementation ("com.google.android.gms:play-services-mlkit-barcode-scanning:18.3.1")
// RxJava 3.1.3
    implementation("io.reactivex.rxjava3:rxjava:3.1.3")
    implementation("io.reactivex.rxjava3:rxandroid:3.0.0")

    //facebook
    implementation("com.facebook.android:facebook-android-sdk:[8,9)")
}