//
//  Value+Extension.swift
//  PhoneManager
//
//  Created by edy on 2025/3/21.
//

import Foundation
import AudioToolbox
import CoreHaptics


extension Int {
    
    func RW() -> Double {
        
        return Double(self) * RScreenW()
    }
    
    func RWI() -> Int {
        
        return Int(self) * Int(RScreenW())
    }
    
    func RH() -> Double {
        
        return Double(self) * RScreenH()
    }
    
    func RHI() -> Int {
        
        return Int(self) * Int(RScreenH())
    }
    
    func R(ratio:CGFloat) -> Double {
        
        return Double(self) * ratio
    }
}

extension Float {
    
    func RW() -> Double {
        
        return Double(self) * RScreenW()
    }
    
    func RWI() -> Int {
        
        return Int(self) * Int(RScreenW())
    }
    
    func RH() -> Double {
        
        return Double(self) * RScreenH()
    }
    
    func RHI() -> Int {
        
        return Int(self) * Int(RScreenH())
    }
    
    func R(ratio:CGFloat) -> Double {
        
        return Double(self) * ratio
    }
}

extension Double {
    
    func RW() -> Double {
        
        return Double(self) * RScreenW()
    }
    
    func RWI() -> Int {
        
        return Int(self) * Int(RScreenW())
    }
    
    func RH() -> Double {
        
        return Double(self) * RScreenH()
    }
    
    func RHI() -> Int {
        
        return Int(self) * Int(RScreenH())
    }
    
    func R(ratio:CGFloat) -> Double {
        
        return Double(self) * ratio
    }
}

extension CGFloat {
    
    func RW() -> Double {
        
        return Double(self) * RScreenW()
    }
    
    func RWI() -> Int {
        
        return Int(self) * Int(RScreenW())
    }
    
    func RH() -> Double {
        
        return Double(self) * RScreenH()
    }
    
    func RHI() -> Int {
        
        return Int(self) * Int(RScreenH())
    }
    
    func R(ratio:CGFloat) -> Double {
        
        return Double(self) * ratio
    }
}

extension NSObject {
    
    public func vibrate(_ all:Bool? = nil) -> Void {
        if all != nil {
            DispatchQueue.main.async {
                HapticManager.share.triggerHapticFeedback()
            }
        }else{
            if SettingConfiguration.share.config.vibration ?? false {
                DispatchQueue.main.async {
                    HapticManager.share.triggerHapticFeedback()
                }
            }
        }
    }
}

extension UISwitch {
    
    @IBInspectable var isVibration:Bool {
        set{
            self.addTarget(self, action: #selector(valueChangeVibration), for: .valueChanged)
        }
        get{
            return false
        }
    }
    
    @objc func valueChangeVibration() -> Void {
        self.vibrate(true)
    }
    
}


class HapticManager {
    
    static let share = HapticManager()
    private var engine: CHHapticEngine?
    
    init() {
        setupHapticEngine()
    }
    
    func setupHapticEngine() {
        guard CHHapticEngine.capabilitiesForHardware().supportsHaptics else { return }
        
        do {
            engine = try CHHapticEngine()
            try engine?.start()
            generator.prepare()
        } catch {
            print("引擎初始化失败: \(error)")
        }
    }
    
    private lazy var generator: UIImpactFeedbackGenerator = {
        let genter = UIImpactFeedbackGenerator(style: .medium)
        genter.prepare()
        return genter
    }()
    
    // 触发震动反馈
    func triggerHapticFeedback() {
        generator.impactOccurred()
    }
    
}
