//
//  ScreenHeightRatioConstraint.swift
//  PhoneManager
//
//  Created by edy on 2025/4/28.
//

import Foundation
import UIKit

class ScreenHeightRatioConstraint: NSLayoutConstraint {
    
    // 存储比例基准值（812）
    private let standardHeight: CGFloat = 812.0
    
    override func awakeFromNib() {
        super.awakeFromNib()
        updateConstant()
    }
    
    private func updateConstant() {
        // 获取当前屏幕高度
        let screenHeight = UIScreen.main.bounds.height
        
        // 确保 screenHeight 和 standardHeight 都是有效的
        guard standardHeight.isFinite && screenHeight.isFinite else {
            self.constant = 0 // 设置为默认值以避免崩溃
            return
        }
        
        // 计算新的约束常量（直接使用屏幕高度与标准高度的比率）
        let calculatedConstant = (screenHeight /  812.0) * self.constant
        
        // 检查 calculatedConstant 是否为有限值
        if calculatedConstant.isFinite {
            self.constant = calculatedConstant
        } else {
            self.constant = 0 // 设置为默认值以避免崩溃
        }
    }
}


class ScreenWidthRatioConstraint: NSLayoutConstraint {
    
    // 存储比例基准值（812）
    private let standardWidth: CGFloat = 375.0
    
    override func awakeFromNib() {
        super.awakeFromNib()
        updateConstant()
    }
    
    private func updateConstant() {
        // 获取当前屏幕高度
        let screenWidth = UIScreen.main.bounds.width
        
        // 确保 screenHeight 和 standardHeight 都是有效的
        guard standardWidth.isFinite && screenWidth.isFinite else {
            self.constant = 0 // 设置为默认值以避免崩溃
            return
        }
        
        // 计算新的约束常量（直接使用屏幕高度与标准高度的比率）
        let calculatedConstant = (screenWidth /  375.0) * self.constant
        
        // 检查 calculatedConstant 是否为有限值
        if calculatedConstant.isFinite {
            self.constant = calculatedConstant
        } else {
            self.constant = 0 // 设置为默认值以避免崩溃
        }
    }

}
