//
//  UserDef.swift
//  PhoneManager
//
//  Created by zxhy on 2025/3/19.
//

import Foundation

class UserDef:NSObject {
    
    static let shard:UserDef = UserDef()
    
    var isShowLanding:Bool = false
    
    var isFirstStart:Bool = true
    
    override init() {
        
        let defaults:UserDefaults = UserDefaults.standard
        
        self.isShowLanding = defaults.value(forKey: "isShowLanding") as? Bool ?? false
        
        self.isFirstStart = defaults.value(forKey: "isFirstStart") as? Bool ?? true
    }
    
    func saveUserDefToSandBox() {
    
        let defaults:UserDefaults = UserDefaults.standard
        
        defaults.setValue(UserDef.shard.isShowLanding, forKey: "isShowLanding")
        
        defaults.synchronize()
    }
    
    
    func saveFirstStart(){
        
        let defaults:UserDefaults = UserDefaults.standard
        
        defaults.setValue(false, forKey: "isFirstStart")
        
        defaults.synchronize()
    }
    
    class func saveKeyWithValue(key:String,value:Any) {
    
        UserDefaults.standard.set(value, forKey: key)
    }
}


