//
//  PMButton.swift
//  PhoneManager
//
//  Created by edy on 2025/4/8.
//

import UIKit

enum ButtonStyleType {
    case ButtonStyleTypeDiamond
    case ButtonStyleTypeNormal
}

class PMButton: UIButton {

    override init(frame: CGRect) {
        super.init(frame: frame)
        self.layer.cornerRadius = 12
        self.clipsToBounds = true
    }
    
    var isSelect:Bool = false {
        didSet {
            if isSelect {
                self.layer.borderColor = UIColor.colorWithHex(hexStr: "#266BFF").cgColor
                self.layer.borderWidth = 1
                self.gradient(colors: [UIColor.colorWithHex(hexStr: "#FFFFFF"),UIColor.colorWithHex(hexStr: "#E3E9FC")])
            }else{
                self.layer.borderColor = UIColor.clear.cgColor
                self.layer.borderWidth = 0
                self.gradient(colors: [.clear])
            }
        }
    }
    
    var labels : [UILabel] = []
    
    var buttonStyleType : ButtonStyleType = .ButtonStyleTypeNormal
    
    func setTitles(_ titles: [String] ) {
        if labels.count == titles.count {
            for i in 0..<titles.count {
                let lb:UILabel = labels[i]
                lb.text = titles[i]
            }
            return
        }
        if titles.count > 1 {
            let t = UILabel()
            t.text = titles[0]
            t.textColor = .colorWithHex(hexStr: "#333333")
            t.font = UIFont.boldSystemFont(ofSize: 16)
            self.addSubview(t)
            t.snp.makeConstraints { make in
                if buttonStyleType == .ButtonStyleTypeNormal{
                    make.centerY.equalToSuperview()
                    make.left.equalToSuperview().offset(10)
                }else {
                    make.left.equalToSuperview().offset(10)
                    make.bottom.equalTo(self.snp.centerY).offset(-2)
                }
               
            }
            let b = UILabel()
            b.text = titles[1]
            b.textColor = .colorWithHex(hexStr: "#666666")
            b.font = UIFont.boldSystemFont(ofSize: 12)
            addSubview(b)
            b.snp.makeConstraints { make in
                if buttonStyleType == .ButtonStyleTypeNormal{
                    make.centerY.equalToSuperview()
                    make.right.equalToSuperview().offset(-10)
                }else {
                    make.left.equalToSuperview().offset(10)
                    make.top.equalTo(self.snp.centerY)
                }
            }
            labels.append(t)
            labels.append(b)
        }else if titles.count == 1 {
            let t = UILabel()
            t.text = titles[0]
            t.textColor = .colorWithHex(hexStr: "#333333")
            t.font = UIFont.boldSystemFont(ofSize: 16)
            self.addSubview(t)
            t.snp.makeConstraints { make in
                make.left.equalToSuperview().offset(10)
                make.centerY.equalToSuperview()
            }
            labels.append(t)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}
