//
//  PMScaleImageView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/7.
//

import UIKit

class PMScaleImageView: UIView , UIScrollViewDelegate {

    override init(frame: CGRect) {
        super.init(frame: frame)
        setup()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
        setup()
    }
    
    var localIdentifier:String?{
        didSet {
            guard let localIdentifier = localIdentifier else{
                return
            }
            showImg.asset.load(withLocalIdentifier: localIdentifier) {[weak self] image in
                guard let weakSelf = self else { return }
                weakSelf.icon = image
            }
            
            
        }
    }
    
    var icon:UIImage? {
        didSet {
            showImg.image = icon
            DispatchQueue.main.asyncAfter(deadline: .now()+0.1, execute: {
                self.layoutIfNeeded()
                var size = self.icon?.size ?? CGSize()
                if size.width > self.width {
                    size.width = self.width
                    size.height = size.height * (self.width / (self.icon?.size.width ?? 1))
                }
                if size.height > self.height {
                    size.height = self.height
                    size.width = size.width * (self.height / (self.icon?.size.height ?? 1))
                }
                self.showImg.snp.remakeConstraints({ make in
                    make.left.equalToSuperview().offset((self.width - size.width)/2.0 )
//                    if size.height < self.height / 2.0 {
//                        make.top.equalToSuperview().offset((self.height - size.height)/2.0 - 20 )
//                    }else if self.height - size.height > 20 {
//                        make.top.equalToSuperview().offset(10)
//                    }else{
                        make.top.equalToSuperview().offset((self.height - size.height)/2.0 )
//                    }
                    make.size.equalTo(size)
                })
            })
        }
    }

    private func setup() -> Void {
        scroll.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
    }
    
    lazy var showImg: UIImageView = {
        let iv = UIImageView()
        iv.contentMode = .scaleAspectFill
        scroll.addSubview(iv)
        return iv
    }()
    
    private lazy var scroll: UIScrollView = {
        let scroll = UIScrollView()
        scroll.delegate = self
        scroll.showsVerticalScrollIndicator = false
        scroll.showsHorizontalScrollIndicator = false
        scroll.minimumZoomScale = 1.0
        scroll.maximumZoomScale = 4.0
        addSubview(scroll)
        return scroll
    }()
    
    func scrollViewDidZoom(_ scrollView: UIScrollView) {
        if scrollView.zoomScale > 1.5 {
            self.Radius = 16
        }else{
            self.Radius = 0
        }
    }
    
    func viewForZooming(in scrollView: UIScrollView) -> UIView? {
        return showImg
    }
}
