//
//  PMTextField.swift
//  PhoneManager
//
//  Created by edy on 2025/5/12.
//

import UIKit

class PMTextField: UITextField {

    var contentInsets = UIEdgeInsets()
    
    override func borderRect(forBounds bounds: CGRect) -> CGRect {
        let rect = super.borderRect(forBounds: bounds)
        return math(rect)
    }
  
    override func textRect(forBounds bounds: CGRect) -> CGRect {
        let rect = super.textRect(forBounds: bounds)
        return math(rect)
    }
    
    override func placeholderRect(forBounds bounds: CGRect) -> CGRect {
        let rect = super.placeholderRect(forBounds: bounds)
        return CGRect(
                    x: rect.origin.x,
                    y: (bounds.height - rect.height) / 2,
                    width: rect.width,
                    height: rect.height
                )
    }
    
    override func editingRect(forBounds bounds: CGRect) -> CGRect {
        let rect = super.editingRect(forBounds: bounds)
        return math(rect)
    }
    
    private func math(_ bounds:CGRect) -> CGRect {
        var rect = bounds
        rect.origin.x = contentInsets.left
        rect.origin.y = contentInsets.top
        rect.size.width = rect.size.width - contentInsets.left - contentInsets.right
        rect.size.height = rect.size.height - contentInsets.top - contentInsets.bottom
        return rect
    }
    

}
