//
//  SystemCommentManager.swift
//  PhoneManager
//
//  Created by edy on 2025/4/29.
//

import Foundation
class SystemCommentManager {
    
    
    // 记录评价时间
    private static let SHOW_COMMENT_DATE = "showCommentDate"
    
    // 当天是否评价
    private static let SHOW_COMMENT_IN_CURRENT_DAY = "showCommentInCurrentDay"
    
    
    /// 弹窗评论
    class func showCommentPage(_ view:UIView){
        if let date = UserDefaults.standard.object(forKey: SHOW_COMMENT_DATE){
            // 如果是有时间，判断和当前时间是不是一致的，如果是一致
            let calendar = Calendar.current
            let isSameDay = calendar.isDate(date as! Date, inSameDayAs: Date())
            if !isSameDay {
                initCommentInfoInDisk()
            }
        }else{
            initCommentInfoInDisk()
        }
        // 首先是免费三次机会用完之后，第四次点击广告，在结果页点击棒极了（删除成功，且loading页面消失）
        if ADManager.shared.defaultFreeTimes == 0 {
            // 判断当天有没有被触发过
            if let isCommentInCurrentDay = UserDefaults.standard.object(forKey: SHOW_COMMENT_IN_CURRENT_DAY){
                let temp : Bool = isCommentInCurrentDay as! Bool
                if !temp {
                    showAction(view)
                }
            }else{
                showAction(view)
            }
        }
    }
    
    /// 显示评价弹窗操作
    private class func showAction(_ view : UIView){
        DispatchQueue.main.async {
            let rate = CustomRate()
            view.showBlur()
            rate.view.callblock = {
                view.hideBlur()
            }
            rate.show()
        }
        UserDefaults.standard.set(true, forKey: SHOW_COMMENT_IN_CURRENT_DAY)
        UserDefaults.standard.set(Date(), forKey: SHOW_COMMENT_DATE)
    }
    
    
    
    /// 初始化评价的基础信息
    private class func initCommentInfoInDisk(){
        UserDefaults.standard.set(false, forKey: SHOW_COMMENT_IN_CURRENT_DAY)
        UserDefaults.standard.set(Date(), forKey: SHOW_COMMENT_DATE)
    }
}
