//
//  EmailCleanTopView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/9.
//

import UIKit

class EmailCleanTopView: UIView {
    
    var callblock:(()->Void) = {}
    
    private func setup() -> Void {
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(marginLR)
            make.top.equalToSuperview().offset(20)
        }
        settingsButton.snp.makeConstraints { make in
            make.right.equalToSuperview().inset(marginLR)
            make.centerY.equalTo(titleLabel.snp.centerY)
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setup()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "Email Cleaner"
        label.font = UIFont.systemFont(ofSize: 20, weight: .bold)
        label.textColor = .black
        label.textAlignment = .left
        addSubview(label)
        return label
    }()
    
    private lazy var settingsButton: UIButton = {
        let button = UIButton(type: .custom)
        button.clipsToBounds = true
        button.setImage(UIImage(named: "ic_switch_email"), for: .normal)
        button.addTarget(self, action: #selector(filter), for: .touchUpInside)
        addSubview(button)
        return button
    }()
    
    @objc private func filter() -> Void {
        callblock()
    }
}
