//
//  EmailCleanController.swift
//  PhoneManager
//
//  Created by edy on 2025/5/9.
//

import UIKit

class EmailCleanController: BaseViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        setup()
        NotificationCenter.default.addObserver(self, selector: #selector(uupddate), name: messageUpdate, object: nil)
        contentView.beginLoading()
    }
    
    @objc func uupddate() -> Void {
        DispatchQueue.main.async {
            self.contentView.endLoading()
            self.contentView.datasource = PMEmailManager.shareManager.allMessage
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        DispatchQueue.main.async {
            self.contentView.datasource = PMEmailManager.shareManager.allMessage
        }
    }
    
    private func setup() -> Void {
        contentView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(titleView.snp.bottom)
        }
    }
    
    private lazy var contentView: EmailContentView = {
        let content = EmailContentView(self)
        view.addSubview(content)
        content.callblock = { [weak self] show in
            guard let self = self else { return }
            if show {
                self.view.showBlur()
            }else{
                self.view.hideBlur()
            }
        }
        return content
    }()
    
    deinit {
        NotificationCenter.default.removeObserver(self, name: messageUpdate, object: nil)
    }
}
