//
//  EmailKeywordCollectionFlowLayout.swift
//  PhoneManager
//
//  Created by edy on 2025/5/12.
//

import UIKit

class EmailKeywordCollectionFlowLayout: UICollectionViewFlowLayout {
    
    override func layoutAttributesForElements(in rect: CGRect) -> [UICollectionViewLayoutAttributes]? {
        guard let attributes = super.layoutAttributesForElements(in: rect) else { return nil }
        
        var leftMargin = sectionInset.left // 每行起始位置:ml-citation{ref="4,7" data="citationList"}
        var currentY = CGFloat(-1)
        
        return attributes.map { attr in
            // 换行重置边距:ml-citation{ref="5" data="citationList"}
            if attr.frame.origin.y != currentY {
                leftMargin = sectionInset.left
                currentY = attr.frame.origin.y
            }
            
            // 调整 X 坐标实现左对齐:ml-citation{ref="7" data="citationList"}
            attr.frame.origin.x = leftMargin
            leftMargin += attr.frame.width + minimumInteritemSpacing
            
            return attr
        }
    }
}
