//
//  EmailFilterKeywordCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/12.
//

import UIKit

class EmailFilterKeywordCell: UITableViewCell {

    static let id = "EmailFilterKeywordCell"
    
    @IBOutlet weak var kwTitleL: UILabel!
    
    var callblock:((String,Bool)->Void) = { event, select in}
    @IBOutlet weak var emSwitch: UISwitch!
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }

    @IBAction func switchValueChange(_ sender: UISwitch) {
        self.vibrate()
        callblock("switch",sender.isOn)
    }
    
    var top:Bool = false
    var bot:Bool = false
    
    func reload() -> Void {
        DispatchQueue.main.async {
            if self.top && self.bot {
                self.cornerCut(radius: 12, corner: [.allCorners])
            }else if self.top {
                self.cornerCut(radius: 12, corner: [.topLeft,.topRight])
            }else if self.bot {
                self.cornerCut(radius: 12, corner: [.bottomLeft,.bottomRight])
            }else{
                self.cornerCut(radius: 0, corner: [.allCorners])
            }
        }
    }
    
    @IBAction func AddKeyWordActions(_ sender: Any) {
        callblock("keyword",true)
    }
}

