//
//  WidgetViewController.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import UIKit

class WidgetViewController: BaseViewController {

    enum widgetType:Int {
        case battery = 0
        case storage = 1
        case bothThem = 2
    }
    
    var widgets:widgetType = .battery {
        didSet {
            topButs.type = self.widgets.rawValue
            batterySta.widgetType = self.widgets.rawValue
        }
    }
    
    var widgetMode = 0 {// 0 1 2
        didSet{
            batterySta.widgetMode = widgetMode
            born.widgetMode = widgetMode
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .white
        setUI()
        let infoBut = UIButton(type: .custom)
        infoBut.setImage(UIImage(named: "ic_widget_InfoRight"), for: .normal)
        infoBut.addTarget(self, action: #selector(infoRightAction), for: .touchUpInside)
        titleView.addSubview(infoBut)
        infoBut.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-15)
            make.centerY.equalTo(titleView.backBtn.centerY)
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        widgetMode = 0
    }
    
    @objc func setWidgetTouch() -> Void {
        let battery = WidgetPublicModel.battery()
        let storage = WidgetPublicModel.UseDiskSpace() * 100
        var widgetIdx = 0
        widgetIdx = widgets.rawValue * 10 + widgetMode
        widgetAppgourp.share.PushWidgetData(widgetIdx, battery: Int(battery), storage: Int(storage))
        
        let save = EmailSaveController()
        save.state = .success
        save.modalTransitionStyle = .crossDissolve
        save.modalPresentationStyle = .overFullScreen
        self.present(save, animated: true)
        DispatchQueue.main.asyncAfter(deadline: .now()+1.5) {
            save.dismiss(animated: true) {
                self.dismiss(animated: true)
                if self.isJumpExample == false {
                    self.jumpGuidePage()
                }
            }
        }
    }
    
    var isJumpExample:Bool {
        set {
            UserDefaults.standard.set(newValue, forKey: "widgetStartIn")
            UserDefaults.standard.synchronize()
        }
        get {
            return UserDefaults.standard.bool(forKey: "widgetStartIn")
        }
    }
    
    @objc private func infoRightAction() -> Void {
        jumpGuidePage()
    }
    
    func jumpGuidePage() -> Void {
        if isJumpExample {
            let example = PMWidgetExampleController()
            example.modalPresentationStyle = .overFullScreen
            self.present(example, animated: true)
        }else{
            isJumpExample = true
            let guide = PMWidgetGuideStartController()
            let guideM = UINavigationController(rootViewController: guide)
            guideM.modalPresentationStyle = .overFullScreen
            guide.callblock = {[weak self] in
                guard let self = self else { return }
                let example = PMWidgetExampleController()
                guide.navigationController?.pushViewController(example, animated: true)
            }
            self.present(guideM, animated: true)
        }
    }
    
    func setUI() -> Void {
        titleL.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.top.equalTo(titleView.snp.bottom).offset(10)
        }
        topButs.snp.makeConstraints { make in
            make.top.equalTo(titleL.snp.bottom).offset(22)
            make.left.right.equalToSuperview().inset(15)
            make.height.equalTo(46)
        }
        batterySta.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(topButs.snp.bottom).offset(64)
            make.size.equalTo(CGSize(width: 164, height: 164))
        }
        widgetPageCtrol.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(batterySta.snp.bottom).offset(50)
        }
        born.snp.makeConstraints { make in
            make.top.equalTo(batterySta.snp.top)
            make.left.right.equalToSuperview().inset(30)
            make.height.equalTo(born.snp.width)
        }
        statesBottom.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.size.equalTo(CGSize(width: 180, height: 40))
            make.top.equalTo(born.snp.bottom).offset(20)
        }
        setWidgetBtn.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(15)
            make.bottom.equalToSuperview().offset(-30)
            make.height.equalTo(46)
        }
    }
    
    private lazy var titleL: UILabel = {
        let l = UILabel()
        l.text = "Widgets"
        l.font = UIFont.boldSystemFont(ofSize: 20)
        l.textColor = .black
        view.addSubview(l)
        return l
    }()
    
    private lazy var topButs: WidgetTopStackView = {
        let topbuts = WidgetTopStackView()
        topbuts.type = self.widgets.rawValue
        topbuts.callback = { [weak self] idx in
            self?.born.isHidden = true
            if idx == 0 {
                self?.widgets = .battery
                self?.widgetPageCtrol.currentPage = 0
            }else if idx == 1{
                self?.widgets = .storage
                self?.widgetPageCtrol.currentPage = 1
            }else{
                self?.born.isHidden = false
                self?.widgets = .bothThem
                self?.widgetPageCtrol.currentPage = 2
            }
        }
        view.addSubview(topbuts)
        return topbuts
    }()
    
    private lazy var born: WidgetBornThenView = {
        let born = WidgetBornThenView()
        born.layer.cornerRadius = 20
        born.isHidden = true
        view.addSubview(born)
        return born
    }()
    
    private lazy var batterySta: WidgetBatteryStView = {
        let stav = WidgetBatteryStView()
        stav.layer.cornerRadius = 20
        stav.widgetType = self.widgets.rawValue
        stav.widgetMode = widgetMode
        view.addSubview(stav)
        return stav
    }()
    
    private lazy var widgetPageCtrol: UIPageControl = {
        let page = UIPageControl()
        page.currentPage = 0
        page.numberOfPages = 3
        page.currentPageIndicatorTintColor = .colorWithHex(hexStr: "#0082FF")
        page.pageIndicatorTintColor = .colorWithHex(hexStr: "#C6CEE0")
        view.addSubview(page)
        page.isHidden = true
        return page
    }()
    
    private lazy var statesBottom: WidgetStatesView = {
        let bottom = WidgetStatesView(3)
        bottom.callback = { [weak self] idx in
            self?.widgetMode = idx
        }
        view.addSubview(bottom)
        return bottom
    }()
    
    private lazy var setWidgetBtn: UIButton = {
        let btn = UIButton(type: .custom)
        btn.setTitle("Set Widget", for: .normal)
        btn.titleLabel?.font = UIFont.boldSystemFont(ofSize: 16)
        btn.setTitleColor(.white, for: .normal)
        btn.addTarget(self, action: #selector(setWidgetTouch), for: .touchUpInside)
        view.addSubview(btn)
        btn.backgroundColor = .colorWithHex(hexStr: "#0082FF")
        btn.layer.cornerRadius = 8
        return btn
    }()
}
