//
//  WidgetKeepListViewController.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import UIKit

class WidgetKeepListViewController: BaseViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        setUI()
    }

    private func setUI() -> Void {
        keepL.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.top.equalTo(titleView.snp.bottom).offset(10)
        }
        NotData.snp.makeConstraints { make in
            make.centerX.centerY.equalToSuperview()
        }
    }
    
    private lazy var keepL: UILabel = {
        let l = UILabel()
        l.text = "Keep List"
        l.font = UIFont.boldSystemFont(ofSize: 20)
        l.textColor = .black
        view.addSubview(l)
        return l
    }()

    private lazy var NotData: UIImageView = {
        let no = UIImageView(image: UIImage(named: "img_photo_defpage"))
        no.contentMode = .scaleToFill
        view.addSubview(no)
        return no
    }()
    
}
