//
//  WidgetTopStackView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import UIKit

class WidgetTopStackView: UIView {

    override init(frame: CGRect) {
        super.init(frame: frame)
        layer.cornerRadius = 8
        backgroundColor = .colorWithHex(hexStr: "#F2F6FC")
        clipsToBounds = true
        setUI()
    }
    
    var callback:((_ idx:Int)->Void)?
    
    var type : Int = 0 {
        didSet  {
            if type == 0 {
                battryBtn.isSelected = true
                storageBtn.isSelected = false
                
                battryBtn.backgroundColor = .white
                storageBtn.backgroundColor = .clear
                
                bronThem.isSelected = false
                bronThem.backgroundColor = .clear
                
            }else if type == 1{
                battryBtn.isSelected = false
                storageBtn.isSelected = true
                battryBtn.backgroundColor = .clear
                storageBtn.backgroundColor = .white
                bronThem.isSelected = false
                bronThem.backgroundColor = .clear
            }else{
                battryBtn.isSelected = false
                storageBtn.isSelected = false
                battryBtn.backgroundColor = .clear
                storageBtn.backgroundColor = .clear
                bronThem.isSelected = true
                bronThem.backgroundColor = .white
            }
        }
    }
    
    @objc private func widgetTouchs(_ sender:UIButton) -> Void {
        guard callback != nil else {
            return
        }
        callback!(sender.tag)
    }
    
    private func setUI() -> Void {
        stack.snp.makeConstraints { make in
            make.left.top.bottom.right.equalToSuperview().inset(4)
        }
        stack.addArrangedSubview(battryBtn)
        stack.addArrangedSubview(storageBtn)
        stack.addArrangedSubview(bronThem)
//        battryBtn.snp.makeConstraints { make in
//            make.left.top.bottom.equalToSuperview().inset(4)
//            make.width.equalTo(self.snp.width).multipliedBy(1/3.0).offset(-8)
//        }
//        storageBtn.snp.makeConstraints { make in
//            make.top.bottom.equalToSuperview().inset(4)
//            make.left.equalTo(battryBtn.snp.right)
//            make.width.equalTo(battryBtn.snp.width)
//        }
//        bronThem.snp.makeConstraints { make in
//            make.right.top.bottom.equalToSuperview().inset(4)
//            make.left.equalTo(storageBtn.snp.right)
//        }
    }
    
    private lazy var stack: UIStackView = {
        let stack = UIStackView()
        stack.spacing = 2
        stack.axis = .horizontal
        stack.alignment = .fill
        stack.distribution = .fillEqually
        addSubview(stack)
        return stack
    }()
    
    private lazy var battryBtn: UIButton = {
        let b = UIButton(type: .custom)
        b.tag = 0
        b.setTitle("Battery", for: .normal)
        b.setTitleColor(.colorWithHex(hexStr: "#B3B3B3"), for: .normal)
        b.setTitleColor(.colorWithHex(hexStr: "#0082FF"), for: .selected)
        b.addTarget(self, action: #selector(widgetTouchs(_:)), for: .touchUpInside)
        b.layer.cornerRadius = 4
        return b
    }()
    
    private lazy var storageBtn: UIButton = {
        let b = UIButton(type: .custom)
        b.tag = 1
        b.setTitle("Storage", for: .normal)
        b.setTitleColor(.colorWithHex(hexStr: "#B3B3B3"), for: .normal)
        b.setTitleColor(.colorWithHex(hexStr: "#0082FF"), for: .selected)
        b.addTarget(self, action: #selector(widgetTouchs(_:)), for: .touchUpInside)
        b.layer.cornerRadius = 4
        return b
    }()
    
    private lazy var bronThem: UIButton = {
        let b = UIButton(type: .custom)
        b.tag = 2
        b.setTitle("Both", for: .normal)
        b.setTitleColor(.colorWithHex(hexStr: "#B3B3B3"), for: .normal)
        b.setTitleColor(.colorWithHex(hexStr: "#0082FF"), for: .selected)
        b.addTarget(self, action: #selector(widgetTouchs(_:)), for: .touchUpInside)
        b.layer.cornerRadius = 4
        return b
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}
