//
//  WidgetStatesView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import UIKit

class WidgetStatesView: UIView {

    private var count = 0
    
    var callback:((_ idx:Int)->Void)?
    
    @objc func widgetModeTouch(_ sender:UIButton) -> Void {
        if sender.isSelected {
            return
        }
        guard let sup = sender.superview else { return }
        for b in sup.subviews {
            guard let btn:UIButton = b as? UIButton else { return }
            btn.isSelected = false
        }
        sender.isSelected = true
        guard callback != nil else { return }
        callback!(sender.tag)
    }
    
    func setUI() -> Void {
        widgetStack.snp.makeConstraints { make in
            make.left.top.bottom.right.equalToSuperview()
        }
        for i in 0..<count {
            let b = UIButton(type: .custom)
            let imgn = String(format: "img_widgets_n_%d", i)
            b.setImage(UIImage(named: imgn), for: .normal)
            let imgs = String(format: "img_widgets_s_%d", i)
            b.setImage(UIImage(named: imgs), for: .selected)
            b.tag = i
            if i == 0 {
                b.isSelected = true
            }
            b.snp.makeConstraints { make in
                make.width.equalTo(b.snp.height).multipliedBy(1)
            }
            b.addTarget(self, action: #selector(widgetModeTouch(_:)), for: .touchUpInside)
            widgetStack.addArrangedSubview(b)
        }
    }
    
    private lazy var widgetStack: UIStackView = {
        let stack = UIStackView()
        stack.axis = .horizontal
        stack.alignment = .fill
        stack.distribution = .equalCentering
        addSubview(stack)
        return stack
    }()
    
    init(_ count:Int) {
        super.init(frame: CGRectZero)
        self.count = count
        setUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}
