//
//  WidgetBatteryStView.swift
//  PhoneManager
//
//  Created by edy on 2025/4/2.
//

import UIKit

class WidgetBatteryStView: UIView ,BatteryStatusDelegate {

    var widgetType = 0 {
        didSet{
            if widgetType == 0 {
                widgetT.text = "Battery"
                widgetR.text = String(format: "%.0f%%", WidgetPublicModel.battery() )
                staray.isHidden = true
            }else{
                widgetT.text = "Storage"
                let useP = WidgetPublicModel.UseDiskSpace()
                widgetR.text = String(format: "%.0f%%", useP * 100)
                widgetInfo.image = UIImage(named: "img_storage_widgets")
                staray.isHidden = false
            }
            setWidgetInfo()
        }
    }
    
    var widgetMode = 0 {
        didSet{
            if widgetMode == 0 {
                shapeLayer.strokeColor = UIColor.colorWithHex(hexStr: "#FFFFFF").cgColor
                clayer.backgroundColor = UIColor.colorWithHex(hexStr: "#0082FF").cgColor
                layer.shadowColor = UIColor.colorWithHex(hexStr: "#0082FF").cgColor
                widgetT.textColor = .white
                widgetR.textColor = .white
                staray.textColor = .white
            }else if widgetMode == 1 {
                shapeLayer.strokeColor = UIColor.colorWithHex(hexStr: "#0082FF").cgColor
                clayer.backgroundColor = UIColor.colorWithHex(hexStr: "#333333").cgColor
                layer.shadowColor = UIColor.colorWithHex(hexStr: "#333333").cgColor
                widgetT.textColor = .white
                widgetR.textColor = .white
                staray.textColor = .white
            }else{
                shapeLayer.strokeColor = UIColor.colorWithHex(hexStr: "#0082FF").cgColor
                layer.shadowColor = UIColor.colorWithHex(hexStr: "#CCE6FF").cgColor
                clayer.backgroundColor = UIColor.white.cgColor
                widgetT.textColor = .colorWithHex(hexStr: "#0082FF")
                widgetR.textColor = .colorWithHex(hexStr: "#0082FF")
                staray.textColor = .colorWithHex(hexStr: "#0082FF")
            }
            setWidgetInfo()
        }
    }
    
    private func setWidgetInfo() -> Void {
        if widgetType == 0 {
            if widgetMode != 2 {
                widgetInfo.image = UIImage(named: "img_battery_widgets")
            }else{
                widgetInfo.image = UIImage(named: "img_battery_widgets_b")
            }
        }else{
            if widgetMode != 2 {
                widgetInfo.image = UIImage(named: "img_storage_widgets")
            }else{
                widgetInfo.image = UIImage(named: "img_storage_widgets_b")
            }
        }
        self.layoutIfNeeded()
        let path = UIBezierPath()
        let size:CGSize = widgetInfo.bounds.size
        var endangle:CGFloat = 0
        if widgetType == 0 {
            let end:CGFloat = CGFloat(WidgetPublicModel.battery() / 100.0)
            endangle = -Double.pi/2.0 + CGFloat(Double.pi * 2.0 * end)
        }else{
            let useP:CGFloat = WidgetPublicModel.UseDiskSpace()
            endangle = -.pi/2.0 + CGFloat(Double.pi * 2.0 * useP)
        }
        path.addArc(withCenter: CGPoint(x: size.width/2.0, y: size.height/2.0),
                    radius: size.width / 2.0 - 3,
                    startAngle: -Double.pi/2.0,
                    endAngle: endangle,
                    clockwise: true)
        shapeLayer.path = path.cgPath
    }
    
    private func setUI() -> Void {
        widgetInfo.layer.addSublayer(shapeLayer)
        widgetT.snp.makeConstraints { make in
            make.left.top.equalToSuperview().inset(15)
        }
        widgetR.snp.makeConstraints { make in
            make.right.top.equalToSuperview().inset(15)
        }
        widgetInfo.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview().offset(5)
            make.size.equalTo(CGSize(width: 80, height: 80))
        }
        staray.snp.makeConstraints { make in
            make.centerX.equalTo(widgetR.snp.centerX)
            make.top.equalTo(widgetR.snp.bottom).offset(4)
        }
        self.layoutIfNeeded()
        shapeLayer.frame = widgetInfo.bounds
    }
    
    private lazy var widgetT: UILabel = {
        let l = UILabel()
        l.font = UIFont.boldSystemFont(ofSize: 14)
        addSubview(l)
        return l
    }()
    
    private lazy var widgetR: UILabel = {
        let r = UILabel()
        r.font = UIFont.boldSystemFont(ofSize: 14)
        addSubview(r)
        return r
    }()
    
    private lazy var widgetInfo: UIImageView = {
        let info = UIImageView()
        addSubview(info)
        info.contentMode = .scaleToFill
        return info
    }()
    
    private lazy var staray: UILabel = {
        let use = UILabel()
        use.text = "Used"
        use.font = UIFont.systemFont(ofSize: 10)
        addSubview(use)
        return use
    }()

    override init(frame: CGRect) {
        super.init(frame: frame)
        BatteryMonitorManager.shared.delegate = self
        layer.insertSublayer(clayer, at: 0)
        setUI()
    }
    
    func batteryStatusDidUpdate(level: Float, state: UIDevice.BatteryState) {
        if widgetType == 0 {
            widgetR.text = String(format: "%.0f%%", WidgetPublicModel.battery() )
        }
    }
    
    private lazy var clayer: CALayer = {
        let l = CALayer()
        l.backgroundColor = UIColor.white.cgColor
        l.cornerRadius = 20
        return l
    }()
    
    override func layoutSubviews() {
        super.layoutSubviews()
        clayer.frame = self.bounds
        layer.shadowOffset = CGSize(width: 3, height: 3)
        layer.shadowOpacity = 0.7
        layer.shadowRadius = 20.0
        layer.shadowPath = UIBezierPath(rect: bounds).cgPath
        shapeLayer.zPosition = 10
    }
    
    private lazy var shapeLayer: CAShapeLayer = {
        let sh = CAShapeLayer()
        sh.fillColor = UIColor.clear.cgColor
        sh.lineWidth = 6
        sh.lineCap = .round
        return sh
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
