//
//  PMWidgetExampleController.swift
//  PhoneManager
//
//  Created by edy on 2025/5/16.
//

import UIKit

class PMWidgetExampleController: UIViewController ,UIScrollViewDelegate{

    @IBOutlet weak var PMWidgetMainBtn: UIButton!
    @IBOutlet weak var PMWidgetLockBtn: UIButton!
    
    
    @IBOutlet weak var PMWidgetMainScroll: UIScrollView!
    @IBOutlet weak var PMWidgetLockScroll: UIScrollView!
    
    @IBOutlet weak var PMWidgetPage: UIPageControl!
    
    
    @IBOutlet weak var ReturnAction: UIButton!
    @IBOutlet weak var NextActions: UIButton!
    
    var current = 0 {
        didSet{
            if current <= 0 {
                ReturnAction.isHidden = true
            }else{
                ReturnAction.isHidden = false
            }
            NextActions.setTitle("Next", for: .normal)
            if current == 4 {
                NextActions.setTitle("Ok", for: .normal)
            }
            PMWidgetPage.currentPage = current
            
        }
    }
    
    var type = 0 {
        didSet{
            PMWidgetMainScroll.isHidden = !(type == 0)
            PMWidgetLockScroll.isHidden = type == 0
            current = 0
            animation()
        }
    }
    
    private func animation() -> Void {
        if type == 0 {
            let orx = CGFloat(current) * self.PMWidgetMainScroll.width
            UIView.animate(withDuration: 0.3) {
                self.PMWidgetMainScroll.contentOffset = CGPointMake(orx, 0)
            }
        }else{
            let orx = CGFloat(current) * self.PMWidgetLockScroll.width
            UIView.animate(withDuration: 0.3) {
                self.PMWidgetLockScroll.contentOffset = CGPointMake(orx, 0)
            }
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        PMWidgetMainBtn.isSelected = true
        PMWidgetMainBtn.setBackgroundImage(UIImage.Clear(.white), for: .normal)
        PMWidgetMainBtn.setBackgroundImage(UIImage.Clear(UIColor.colorWithHex(hexStr: "#0082FF")), for: .selected)
        
        PMWidgetLockBtn.setBackgroundImage(UIImage.Clear(.white), for: .normal)
        PMWidgetLockBtn.setBackgroundImage(UIImage.Clear(UIColor.colorWithHex(hexStr: "#0082FF")), for: .selected)
        PMWidgetPage.numberOfPages = 5
        PMWidgetMainScroll.delegate = self;
        PMWidgetLockScroll.delegate = self
        type = 0
        self.navigationController?.isNavigationBarHidden = true
    }
    
    func scrollViewDidEndDecelerating(_ scrollView: UIScrollView) {
        ScrollToCurrent(scrollView)
    }
    
    func scrollViewDidEndDragging(_ scrollView: UIScrollView, willDecelerate decelerate: Bool) {
        if decelerate {
            ScrollToCurrent(scrollView)
        }
    }
    
    private func ScrollToCurrent(_ scroll:UIScrollView) -> Void {
        let orx = scroll.contentOffset.x / scroll.width
        PMWidgetPage.currentPage = Int(round(orx))
        current = Int(round(orx))
        if orx == 0 {
            ReturnAction.isHidden = true
        }else{
            ReturnAction.isHidden = false
        }
        NextActions.setTitle("Next", for: .normal)
        if orx == 4 {
            NextActions.setTitle("Ok", for: .normal)
        }
    }
    
    @IBAction func PMWidgetActions(_ sender: UIButton) {
        if sender.isSelected == false {
            if sender == PMWidgetMainBtn {
                PMWidgetLockBtn.isSelected = false
                type = 0
            }else{
                PMWidgetMainBtn.isSelected = false
                type = 1
            }
            sender.isSelected = true
        }
    }
    
    @IBAction func BottomActions(_ sender: UIButton) {
        if sender == ReturnAction {
            self.current -= 1
            animation()
        }else{
            if self.current == 4 {
                self.dismiss(animated: true)
            }else{
                self.current += 1
                animation()
            }
        }
    }
    
    @IBAction func PMClose(_ sender: Any) {
        self.dismiss(animated: true)
    }
}
