//
//  TrashDefaultView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/15.
//

import UIKit

class TrashDefaultView: UIView {
    
    static let jumpToPhotosDetailPageName = Notification.Name("jumpToPhotosDetailPageName")
    static let jumpToVideosDetailPageName = Notification.Name("jumpToVideosDetailPageName")
    
    var mediaType : TrashTypeEnum?
    
    lazy var logImageView : UIImageView = {
        let imageView = UIImageView()
        imageView.image = UIImage(named: "Frame 4")
        return imageView
    }()
    
    lazy var tipLabel: UILabel = {
        let label = UILabel()
        label.text = "Your trash can is empty！!"
        label.textAlignment = .center
        label.textColor = UIColor(red: 0.07, green: 0.07, blue: 0.07, alpha: 1)
        label.font = UIFont.systemFont(ofSize: 17, weight: .semibold)
        label.backgroundColor = .clear
        return label
    }()
    
    lazy var detailTiplabel: UILabel = {
        let label = UILabel()
        label.text = "Once you start sending the video photos to the trash can, they will be displayed here."
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        label.textAlignment = .center
        label.font = UIFont.systemFont(ofSize: 12, weight: .semibold)
        label.backgroundColor = .clear
        label.numberOfLines = 0
        return label
    }()
    
    lazy var startButton : UIButton = {
        let view = UIButton()
        view.setTitle("Clean Now", for: UIControl.State.normal)
        view.setTitleColor(UIColor(red: 1, green: 1, blue: 1, alpha: 1), for: .normal)
        view.titleLabel?.font = UIFont.systemFont(ofSize: 12, weight: .semibold)
        view.clipsToBounds = true
        view.layer.cornerRadius = 16.5
        view.backgroundColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 1)
        view.addTarget(self, action: #selector(startButtonAction), for: .touchUpInside)
        return view
    }()

    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.addSubview(self.logImageView)
        self.addSubview(self.tipLabel)
        self.addSubview(self.detailTiplabel)
        self.addSubview(self.startButton)
        
        self.logImageView.snp.makeConstraints { make in
            make.width.equalTo(230)
            make.height.equalTo(154)
            make.centerX.equalToSuperview()
            make.top.equalToSuperview().offset(105)
        }
        
        self.tipLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.top.equalTo(self.logImageView.snp.bottom).offset(30)
            make.height.equalTo(22)
        }
        self.detailTiplabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.top.equalTo(self.tipLabel.snp.bottom).offset(5)
            make.height.equalTo(44)
        }
        self.startButton.snp.makeConstraints { make in
            make.width.equalTo(107)
            make.height.equalTo(33)
            make.top.equalTo(self.detailTiplabel.snp.bottom).offset(30)
            make.centerX.equalToSuperview()
        }
        
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func startButtonAction(){
        // 跳转页面
        if let type = self.mediaType {
            switch type {
            case .video:
                jumpToVideoDetailPage(type: type)
                break
            case .other,.shot:
                jumpToPhotosDetailPage(type: type)
                break
            }
        }
    }
    
    func jumpToPhotosDetailPage(type: TrashTypeEnum){
        self.responderViewController()?.dismiss(animated: true, completion: {
            NotificationCenter.default.post(name: TrashDefaultView.jumpToPhotosDetailPageName, object: nil,userInfo: ["type":self.mediaType?.rawValue ?? ""])
        })
    }
    func jumpToVideoDetailPage(type: TrashTypeEnum){
        self.responderViewController()?.dismiss(animated: true, completion: {
            NotificationCenter.default.post(name: TrashDefaultView.jumpToVideosDetailPageName, object: nil)
        })

    }
    
}
