//
//  TrashContenViewCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/11.
//

import UIKit

class TrashContenViewCell: UICollectionViewCell {

    @IBOutlet weak var collectionView: UICollectionView!
    
    var trashType:TrashTypeEnum = .video{
        didSet{
            collectionView.reloadData()
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        configUI()
    }
    
    func configUI(){
        let layout = UICollectionViewFlowLayout()
        layout.minimumInteritemSpacing = 12
        layout.minimumLineSpacing = 12
        collectionView.setCollectionViewLayout(layout, animated: false)
        collectionView.delegate = self
        collectionView.dataSource = self
        collectionView.register(UINib(nibName: "TrashContenAssetCell", bundle: nil), forCellWithReuseIdentifier: "TrashContenAssetCell")
        collectionView.register(UINib(nibName: "TrashContenTitleCell", bundle: nil), forCellWithReuseIdentifier: "TrashContenTitleCell")
    }

}

extension TrashContenViewCell:UICollectionViewDelegate,UICollectionViewDataSource,UICollectionViewDelegateFlowLayout{
    
    func numberOfSections(in collectionView: UICollectionView) -> Int{
        return 2
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return section == 0 ? 1 : 20
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if indexPath.section == 0{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TrashContenTitleCell", for: indexPath) as! TrashContenTitleCell
            cell.trashType = trashType
            return cell
        }
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TrashContenAssetCell", for: indexPath) as! TrashContenAssetCell
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize{
        return indexPath.section == 0 ? CGSize(width: ScreenW, height: 92) : CGSize(width: (ScreenW-56)/3, height: (ScreenW-56)/3)
    }

    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, insetForSectionAt section: Int) -> UIEdgeInsets{
        return section == 0 ? UIEdgeInsets() : UIEdgeInsets(top: 0, left: 16, bottom: 0, right: 16)
    }
}
