//
//  TrashContenAssetCell.swift
//  PhoneManager
//
//  Created by edy on 2025/5/11.
//

import UIKit

class TrashContenAssetCell: UICollectionViewCell {
    
    var mediaType : TrashTypeEnum?
    
    var revokeCallBack:()->Void = {}

    @IBOutlet weak var assetImage: UIImageView!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        assetImage.cornerCut(radius: 8, corner: .allCorners)
    }
    
    var model:AssetModel?{
        didSet{
            
            guard let model = model else{return}
            let image = self.mediaType == .video ? "videosmoren" : "photosmoren"
            self.assetImage.asset.load(withLocalIdentifier: model.localIdentifier,placeholder: UIImage.init(named: image))
            
//            if self.mediaType == .video {
//                PhotoAndVideoMananger.mananger.getPreImageFromVideo(identifier: model.localIdentifier, completed: { [weak self] image in
//                    guard let self else {return}
//                    DispatchQueue.main.async {
//                        self.assetImage.image = image
//                    }
//                })
//            }else {
//                DispatchQueue.main.async {
//                    self.assetImage.image = PhotoAndVideoMananger.mananger.getImageFromAssetID(id: model.localIdentifier)
//                }
//            }
        }
    }

    @IBAction func removeClick(_ sender: Any) {
        // 移除数据
        if let model = self.model {
            TrashDataManager.revokeTrashData(mediaType: self.mediaType,identifier: model.localIdentifier) {
                self.revokeCallBack()
            }
        }
        
    }
    
    
}
