//
//  TrashDataManager.swift
//  PhoneManager
//
//  Created by edy on 2025/5/14.
//

import UIKit

class TrashDataManager {
    
    // 撤销当前类型垃圾桶某个数据
    static func revokeTrashData(mediaType: TrashTypeEnum?, identifier:String, comlete:@escaping ()->Void){
        // 清空单利和数据库的数据
        clearCurrentMediaTypeTrashSigtonData(mediaType: mediaType,identifier: identifier)
        clearCurrentMediaTypeTrashDBData(mediaType: mediaType,identifier: identifier)
        comlete()
    }
    
    /// 清除当前类型垃圾桶的所有数据
    static func clearTrashData(mediaType: TrashTypeEnum?,data:[AssetModel], comlete:@escaping ()->Void){
        
        let trashData = self.getCurrentMediaTypeTrashData(mediaType: mediaType)
        if trashData.count > 0 {
            let identifierArray : [String] = data.count == 0 ? trashData.map({$0.localIdentifier}) : data.map({$0.localIdentifier})
            PhotoManager.shared.deleteAssets(localIdentifiers: identifierArray) {
                // 清空单利和数据库的数据
                if data.count > 0 {
                    for item in data {
                        clearCurrentMediaTypeTrashSigtonData(mediaType: mediaType,identifier: item.localIdentifier)
                        clearCurrentMediaTypeTrashDBData(mediaType: mediaType,identifier: item.localIdentifier)
                    }
                }else {
                    clearCurrentMediaTypeTrashSigtonData(mediaType: mediaType)
                    clearCurrentMediaTypeTrashDBData(mediaType: mediaType)
                }
                // 删除完成之后回调
                PhotoManager.shared.removeDataWhenDeleteInPage(data: trashData)
                comlete()
            }
        }else{
            comlete()
        }
    }
    
    static func clearCurrentMediaTypeTrashSigtonData(mediaType:TrashTypeEnum?,identifier:String? = nil){
        if let type = mediaType {
            if identifier == nil{
                Singleton.shared.trashData[type] = []
            }else {
                Singleton.shared.trashData[type] = Singleton.shared.trashData[type]?.filter({$0.localIdentifier != identifier})
            }
           
            Print("删除单利中当前垃圾桶数据成功")
        }
    }
    
    static func clearCurrentMediaTypeTrashDBData(mediaType:TrashTypeEnum?,identifier:String? = nil){
        if let type = mediaType {
            if identifier == nil{
                let dataDB = TrashDatabase.shared.queryByMediaType(type.dbType)
                let success = TrashDatabase.shared.batchDelete(localIdentifiers: dataDB.map({$0.localIdentifier}))
                if !success {
                    Print("删除数据库当前垃圾桶数据失败")
                }
            }else{
                let success = TrashDatabase.shared.delete(localIdentifier: identifier!)
                if !success {
                    Print("删除数据库当前数据失败")
                }
            }
        }
    }
    
    
    static func getCurrentMediaTypeTrashData(mediaType: TrashTypeEnum?) -> [AssetModel]{
        var assetModel : [AssetModel] = []
        if let type  = mediaType{
            // 从数据库拿数据
            let dataDB = TrashDatabase.shared.queryByMediaType(type.dbType)
            for item in dataDB {
                assetModel.append(AssetModel.init(localIdentifier: item.localIdentifier, assetSize: item.assetSize, createDate: item.createDate, mediaType: item.mediaType))
            }
        }
        return assetModel
    }
    

}
