//
//  TipsDuplicatesSimilarController.swift
//  PhoneManager
//
//  Created by edy on 2025/4/27.
//

import UIKit

class TipsDuplicatesSimilarController: UIViewController {

    @IBOutlet weak var lineText: UILabel!
    @IBOutlet weak var startBtn: UIButton!
    
    @IBOutlet weak var iconOne: UIImageView!
    @IBOutlet weak var iconTwo: UIImageView!
    
    @IBOutlet weak var mainTitle: UILabel!
    @IBOutlet weak var subTitle: UILabel!
    
    @IBOutlet weak var duplicate: UILabel!
    @IBOutlet weak var bottomC: ScreenHeightRatioConstraint!
    var type:GuideTipsType = .duplicates
    
    override func viewDidLoad() {
        super.viewDidLoad()

        startBtn.layer.cornerRadius = 23
        
        lineText.text = type.lineText
        iconOne.image = UIImage.init(named: type.tipOneIcon)
        iconTwo.image = UIImage.init(named: type.tipTwoIcon)
        
        mainTitle.text = type.title
        subTitle.text = type.text
        duplicate.isHidden = (type == .similar)
        
        bottomC.constant = kSafeAreaInsets.bottom == 0 ? 30 : 0
    }


    @IBAction func startClick(_ sender: Any) {
        self.dismiss(animated: true)
    }


}
