//
//  SignOutTipView.swift
//  PhoneManager
//
//  Created by edy on 2025/3/31.
//

import Foundation

class SignOutTipView : UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.addSubview(backView)
        self.backView.addSubview(self.contentView)
        self.contentView.addSubview(self.logoView)
        self.contentView.addSubview(self.fLabel)
        self.contentView.addSubview(self.yesButton)
        self.contentView.addSubview(self.cancelButton)
        
        self.contentView.snp.makeConstraints { make in
            make.width.equalTo(295)
            make.height.equalTo(370)
            make.center.equalToSuperview()
        }
        self.logoView.snp.makeConstraints { make in
            make.width.equalTo(192)
            make.height.equalTo(158)
            make.top.equalToSuperview().offset(28)
            make.centerX.equalToSuperview()
        }
        self.fLabel.snp.makeConstraints { make in
            make.top.equalTo(self.logoView.snp.bottom).offset(0)
            make.left.equalToSuperview().offset(24)
            make.right.equalToSuperview().offset(-24)
            make.height.equalTo(56)
        }
        self.yesButton.snp.makeConstraints { make in
            make.top.equalTo(self.fLabel.snp.bottom).offset(16)
            make.left.equalToSuperview().offset(24)
            make.right.equalToSuperview().offset(-24)
            make.height.equalTo(46)
        }
        self.cancelButton.snp.makeConstraints { make in
            make.top.equalTo(self.yesButton.snp.bottom).offset(4)
            make.left.equalToSuperview().offset(24)
            make.right.equalToSuperview().offset(-24)
            make.height.equalTo(46)
        }
    }
    
    lazy var backView : UIView = {
        let maskView = UIView(frame: self.bounds)
        maskView.backgroundColor = UIColor(red: 0, green: 0, blue: 0, alpha: 0.5000)
        return maskView
    }()
    
    lazy var contentView : UIView = {
        let contentView = UIView(frame: self.bounds)
        contentView.backgroundColor = .white
        contentView.layer.cornerRadius = 20
        contentView.layer.masksToBounds = true
        return contentView
    }()
    
    lazy var logoView : UIImageView = {
        let logoView = UIImageView()
        logoView.image = UIImage(named: "img_return_pop")
        logoView.backgroundColor = .clear
        return logoView
        
    }()
    lazy var fLabel : UILabel = {
        let label = UILabel();
        label.text = "Are you sure you want to sign out?"
        label.font = UIFont(name: "PingFang SC-Bold", size: 20)
        label.textColor = UIColor(red: 0.1, green: 0.1, blue: 0.1, alpha: 1)
        label.textAlignment = .center
        label.numberOfLines = 0
        return label
    }()
    lazy var yesButton : UIButton = {
        let sview:UIButton = UIButton()
        
        sview.backgroundColor = UIColor.colorWithHex(hexStr: mColor)
        sview.setTitle("Yes", for: .normal)
        sview.setTitleColor(UIColor.white, for: .normal)
        sview.titleLabel?.font = .systemFont(ofSize: 16, weight: .bold)
        sview.layer.cornerRadius = 23
        sview.layer.masksToBounds = true
        return sview
    }()
    lazy var cancelButton : UIButton = {
        let sview:UIButton = UIButton()
        sview.backgroundColor = .white
        sview.setTitle("Cancel", for: .normal)
        sview.setTitleColor(UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1), for: .normal)
        sview.titleLabel?.font = UIFont(name: "PingFang SC-Bold", size: 16)
        sview.layer.cornerRadius = 23
        sview.layer.masksToBounds = true
        sview.addTarget(self, action: #selector(clickCancelAction), for: UIControl.Event.touchUpInside)
        return sview
    }()
    
    
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func clickCancelAction() {
        self.removeFromSuperview()
    }
}
