//
//  SettingViewHeaderCell.swift
//  PhoneManager
//
//  Created by edy on 2025/3/28.
//

import Foundation

class SettingViewHeaderCell : UITableViewCell {
    
    lazy var logoView : UIImageView = {
        let logoView = UIImageView()
        logoView.layer.cornerRadius = 22.5
        logoView.contentMode = .scaleAspectFit
        logoView.translatesAutoresizingMaskIntoConstraints = false
        logoView.image = UIImage(named: "logo_phone_manager")
        return logoView
        
    }()
    
    lazy var fLabel : UILabel = {
        let label = UILabel();
        if IAPManager.share.isSubscribed == false {
            label.text = "Unlock Unlimited Access"
        }else {
            label.text = "Phone Manager Pro Edition"
        }
       
        label.font = UIFont.systemFont(ofSize: 18, weight: .bold)
        label.textColor = UIColor(red: 0.2, green: 0.2, blue: 0.2, alpha: 1)
        label.textAlignment = .center
        return label
    }()
    
    lazy var sLabel : UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        if IAPManager.share.isSubscribed == false {
            label.text = "Enjoy unlimited access with all Cleanup features"
        }else{
            label.text = "You can now access all Phone Manager features without restrictions"
        }
        label.font = UIFont(name: "PingFang SC-Regular", size: 14)
        label.textColor = UIColor(red: 0.4, green: 0.4, blue: 0.4, alpha: 1)
        label.textAlignment = .center
        
        return label
    }()
    
    lazy var preButtonImageView : UIImageView = {
        let preButtonImageView = UIImageView()
        preButtonImageView.image = UIImage(named: "img_light_setting")
        preButtonImageView.backgroundColor = .clear
        preButtonImageView.isUserInteractionEnabled = true
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(leanMoreBtnClick))
        preButtonImageView.addGestureRecognizer(tap)
        return preButtonImageView
        
    }()
    
    lazy var moreButton : UIButton = {
        let sview:UIButton = UIButton()
        
        sview.backgroundColor = UIColor.colorWithHex(hexStr: mColor)
        sview.setTitle("Learn More", for: .normal)
        sview.setTitleColor(UIColor.white, for: .normal)
        sview.titleLabel?.font = .systemFont(ofSize: 16, weight: .bold)
        
        sview.layer.cornerRadius = 23
        sview.layer.masksToBounds = true
        sview.addTarget(self, action: #selector(leanMoreBtnClick), for: .touchUpInside)
        
        return sview
    }()
    
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        self.selectionStyle = .none
        self.contentView.addSubview(self.logoView)
        self.contentView.addSubview(self.fLabel)
        self.contentView.addSubview(self.sLabel)
        self.contentView.addSubview(self.moreButton)
        self.moreButton.addSubview(self.preButtonImageView)
        
        self.logoView.snp.makeConstraints { make in
            make.width.height.equalTo(150)
            make.centerX.equalToSuperview()
            make.top.equalToSuperview().offset(48)
        }
        
        self.fLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.top.equalTo(self.logoView.snp.bottom).offset(40)
            make.height.equalTo(25)
        }
        self.sLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(15)
            make.right.equalToSuperview().offset(-15)
            make.top.equalTo(fLabel.snp.bottom).offset(4)
            if IAPManager.share.isSubscribed == false {
                make.height.greaterThanOrEqualTo(20)
            }else{
                make.height.equalTo(42)
            }
        }
        
        self.preButtonImageView.snp.makeConstraints { make in
            make.width.height.equalTo(46)
            make.left.equalToSuperview().offset(-56)
            make.top.equalToSuperview()
        }
        
        self.moreButton.snp.makeConstraints { make in
            make.width.equalTo(245)
            if IAPManager.share.isSubscribed == false {
                make.height.equalTo(46)
            }else{
                make.height.equalTo(0)
            }
            make.centerX.equalToSuperview()
            make.top.equalTo(self.sLabel.snp.bottom).offset(20)
        }
        self.layoutIfNeeded()
        if IAPManager.share.isSubscribed == false {
            
        }
        
    }
    
//    lazy var basic: CABasicAnimation = {
//        let basic = CABasicAnimation(keyPath: "position.x")
//        basic.fromValue = -50
//        basic.toValue = self.moreButton.width + 10
//        basic.repeatCount = .infinity
//        preButtonImageView.layer.add(basic, forKey: "position")
//        return basic
//    }()
    
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func leanMoreBtnClick() {
        
        HomePayViewController.show {
            
        }
    }
    
}
