//
//  SecretShowImgDetailView.swift
//  PhoneManager
//
//  Created by edy on 2025/5/20.
//

import UIKit

class SecretShowImgDetailView: UIView {

    var secretCallBack:((Int)->Void) = { select in }
    
    @objc func showImageActions(_ sender:UIButton) -> Void {
        secretCallBack(sender.tag)
    }
    
    private func setup() -> Void {
        shareBtn.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview().inset(16)
            make.right.equalTo(self.snp.centerX).offset(-7.5)
        }
        self.delBtn.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview().inset(16)
            make.left.equalTo(self.snp.centerX).offset(7.5)
        }
        layoutIfNeeded()
        DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
            self.shareBtn.Radius = self.shareBtn.height / 2.0
            self.delBtn.Radius = self.delBtn.height / 2.0
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setup()
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    private lazy var shareBtn: UIButton = {
        let share = UIButton(type: .custom)
        share.setTitle("Share", for: .normal)
        share.setTitleColor(UIColor.colorWithHex(hexStr: "#333333"), for: .normal)
        share.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .medium)
        share.setImage(UIImage(named: "ic_Share_secret"), for: .normal)
        share.backgroundColor = UIColor.colorWithHex(hexStr: "#F2F6FC")
        share.tag = 0
        share.addTarget(self, action: #selector(showImageActions(_:)), for: .touchUpInside)
        addSubview(share)
        return share
    }()
    
    private lazy var delBtn: UIButton = {
        let share = UIButton(type: .custom)
        share.setTitle("Delete", for: .normal)
        share.setTitleColor(UIColor.colorWithHex(hexStr: "#333333"), for: .normal)
        share.setImage(UIImage(named: "ic_Del_secret"), for: .normal)
        share.tag = 1
        share.addTarget(self, action: #selector(showImageActions(_:)), for: .touchUpInside)
        share.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .medium)
        share.backgroundColor = UIColor.colorWithHex(hexStr: "#F2F6FC")
        addSubview(share)
        return share
    }()
}
