//
//  SecretNotDataView.swift
//  PhoneManager
//
//  Created by edy on 2025/3/31.
//

import UIKit

class SecretNotDataView: UIView {

    override init(frame: CGRect) {
        super.init(frame: frame)
        addSubview(info)
        addSubview(NotDataTitle)
        addSubview(NotdataDesc)
        info.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview().offset(-20.RH())
        }
        NotDataTitle.snp.makeConstraints { make in
            make.top.equalTo(info.snp.bottom).offset(24.RH())
            make.centerX.equalToSuperview()
        }
        NotdataDesc.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(30.RH())
            make.top.equalTo(NotDataTitle.snp.bottom).offset(8)
        }
    }
    
    private lazy var NotDataTitle: UILabel = {
        let l = UILabel()
        l.text = "No Secret Files"
        l.textColor = .colorWithHex(hexStr: "#333333")
        l.font = UIFont.boldSystemFont(ofSize: 24)
        l.textAlignment = .center
        return l
    }()
    
    private lazy var info: UIImageView = {
        let info = UIImageView(image: UIImage(named: "img_file_defpage"))
        info.contentMode = .scaleToFill
        return info
    }()
    
    private lazy var NotdataDesc: UILabel = {
        let desc = UILabel()
        desc.text = "Tap to \"Add New\" button to add secret photos and videos"
        desc.textColor = .colorWithHex(hexStr: "#666666")
        desc.font = UIFont.systemFont(ofSize: 14)
        desc.numberOfLines = 0
        desc.textAlignment = .center
        return desc
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

}
