//
//  SecretFirstCell.swift
//  PhoneManager
//
//  Created by edy on 2025/3/31.
//

import UIKit

let SecretFirstCellID = "SecretFirstCell"

class SecretFirstCell: UICollectionViewCell {
 
    override init(frame: CGRect) {
        super.init(frame: frame)
        setUI()
        
        
    }
    
    var callback:(()->Void)?
    
    @objc func SelectTouch() -> Void {
        guard callback != nil else {
            return
        }
        callback!()
    }
    
    private func setUI() -> Void {
        isSelect = false
        infoView.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
        selectInfo.snp.makeConstraints { make in
            make.right.bottom.equalToSuperview().inset(12)
//            make.size.equalTo(CGSize(width: 24, height: 24))
        }
        timeLabe.snp.makeConstraints { make in
            make.left.bottom.equalToSuperview().inset(14)
        }
        
        self.addSubview(self.extensionView)
        self.extensionView.snp.makeConstraints { make in
            make.center.equalTo(self.selectInfo.snp.center)
            make.height.width.equalTo(80)
        }
    }
    
    var isSelect:Bool = false {
        didSet{
            selectInfo.isSelected = isSelect
        }
    }
    
    var imageText:String = "" {
        didSet {
            if imageText.count > 0 {
                imageText.loadPhotoOrVideo {[weak self] duration, icon in
                    self?.infoView.image = icon
                    self?.timeLabe.text = self?.timeStringformatter(Int(duration))
                }
                bringSubviewToFront(selectInfo)
            }
        }
    }
    
    private func timeStringformatter(_ time:Int) -> String {
        if time > 0 {
            let hour = time / 3600
            let minte = (time / 3600) / 60
            let sec = (time % 60)
            return String(format: "%02d:%02d:%02d", hour,minte,sec)
        }
        return ""
    }
    
    private lazy var selectInfo: UIButton = {
        let info = UIButton(type: .custom)
        info.setImage(UIImage(named: "home_info_norl"), for: .normal)
        info.setImage(UIImage(named: "home_info_seleted"), for: .selected)
        info.addTarget(self, action: #selector(SelectTouch), for: .touchUpInside)
        addSubview(info)
        info.contentEdgeInsets = UIEdgeInsets(top: 10, left: 10, bottom: 10, right: 10)
        return info
    }()
    
    lazy var extensionView: UIView = {
        let view = UIView()
        let tap = UITapGestureRecognizer()
        tap.addTarget(self, action: #selector(SelectTouch))
        view.addGestureRecognizer(tap)
        return view
    }()
    
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private lazy var infoView: UIImageView = {
        let info = UIImageView()
        info.contentMode = .scaleAspectFill
        info.image = UIImage.Clear()
        addSubview(info)
        return info
    }()
    
    lazy var timeLabe: UILabel = {
        let l = UILabel()
        l.textColor = .white
        l.font = UIFont.systemFont(ofSize: 14)
        addSubview(l)
        return l
    }()
}
