//
//  SecretBottomView.swift
//  PhoneManager
//
//  Created by edy on 2025/3/31.
//

import UIKit

class SecretBottomView: UIView {

    enum SecretState {
    case add
    case del
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        addSubview(stack)
        addSubview(but)
        but.snp.makeConstraints { make in
            make.height.equalTo(46)
            make.top.left.right.equalToSuperview().inset(15)
        }
        stack.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview().inset(15)
            make.height.equalTo(46)
        }
        layer.insertSublayer(clayer, at: 0)
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        clayer.frame = self.bounds
        layer.shadowColor = UIColor(red: 0, green: 0.51, blue: 1, alpha: 0.1).cgColor
        layer.shadowOffset = CGSize(width: 0, height: -2)
        layer.shadowOpacity = 1
        layer.shadowRadius = 10
        self.backgroundColor = .clear
    }
    
    private lazy var clayer: CALayer = {
        let l = CALayer()
        l.backgroundColor = UIColor.clear.cgColor
        return l
    }()
    
    var callback:((Int)->Void)?
    
    @objc func AddNew() -> Void {
        guard (callback != nil) else {return}
        callback!(-1)
    }
    
    @objc func shareAction() -> Void {
        guard (callback != nil) else {return}
        callback!(0)
    }
    
    @objc func delAction() -> Void {
        guard (callback != nil) else {return}
        callback!(1)
    }
    
    private lazy var but: UIButton = {
        let b = UIButton(type: .custom)
        b.backgroundColor = .colorWithHex(hexStr: "#0082FF")
        b.layer.cornerRadius = 12
        b.clipsToBounds = true
        b.setTitle("Add New", for: .normal)
        b.setImage(UIImage(named: "ic_add_secret"), for: .normal)
        b.titleLabel?.font =  UIFont.systemFont(ofSize: 16, weight: .semibold)
        b.addTarget(self, action: #selector(AddNew), for: .touchUpInside)
        return b
    }()
    
    private lazy var share: UIButton = {
        let b = UIButton(type: .custom)
        b.backgroundColor = .colorWithHex(hexStr: "#F2F6FC")
        b.layer.cornerRadius = 46/2.0
        b.clipsToBounds = true
        b.setTitle("Share", for: .normal)
        b.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .medium)
        b.setImage(UIImage(named: "ic_Share_secret"), for: .normal)
        b.setTitleColor(UIColor.colorWithHex(hexStr: "#333333"), for: .normal)
        b.addTarget(self, action: #selector(shareAction), for: .touchUpInside)
        return b
    }()
    
    private lazy var del: UIButton = {
        let b = UIButton(type: .custom)
        b.backgroundColor = .colorWithHex(hexStr: "#F2F6FC")
        b.layer.cornerRadius = 46/2.0
        b.clipsToBounds = true
        b.setTitle("Delete", for: .normal)
        b.setTitleColor(UIColor.colorWithHex(hexStr: "#333333"), for: .normal)
        b.titleLabel?.font = UIFont.systemFont(ofSize: 14, weight: .medium)
        b.setImage(UIImage(named: "ic_Del_secret"), for: .normal)
        b.addTarget(self, action: #selector(delAction), for: .touchUpInside)
        return b
    }()
    
    private lazy var stack: UIStackView = {
        let st = UIStackView()
        st.isHidden = true
        addSubview(st)
        st.spacing = 15
        st.distribution = .fillEqually
        st.addArrangedSubview(share)
        st.addArrangedSubview(del)
        return st
    }()
    
    var state:SecretState = .add {
        didSet{
            but.isHidden = !(state == .add)
            stack.isHidden = (state == .add)
//            if state == .add {
//                but.setTitle("Add New", for: .normal)
//                but.setImage(UIImage(named: "ic_add_secret"), for: .normal)
//            }else{
//                but.setTitle("Delete", for: .normal)
//                but.setImage(UIImage(), for: .normal)
//            }
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}
